package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 消息类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-04
 */
public enum MessageType {

    P2P("P2P", "点对点"),
    PUBSUB("PUBSUB", "发布订阅");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MessageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MessageType fromCode(String code){
        switch(code) {
            case "P2P":
                return P2P;
            case "PUBSUB":
                return PUBSUB;
            default:
                return null;
        }
    }
}
