package com.xforceplus.ultraman.app.openapirapi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-08-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class VehicleInfo implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 制造商名称
   */
  @TableField("manufacturerName")
  private String manufacturerName;

  /**
   * 车辆类型
   */
  @TableField("vehicleType")
  private String vehicleType;

  /**
   * 汽车品牌
   */
  @TableField("vehicleBrand")
  private String vehicleBrand;

  /**
   * 产地
   */
  @TableField("productionArea")
  private String productionArea;

  /**
   * 机动车合格证编号
   */
  @TableField("certificationNo")
  private String certificationNo;

  /**
   * 进口机动车合格证编号
   */
  @TableField("importCertificateNo")
  private String importCertificateNo;

  /**
   * 商检单号
   */
  @TableField("commodityInspectionNo")
  private String commodityInspectionNo;

  /**
   * 发动机号
   */
  @TableField("engineNo")
  private String engineNo;

  /**
   * 车辆识别号
   */
  @TableField("vehicleNo")
  private String vehicleNo;

  /**
   * 吨位
   */
  private String tonnage;

  /**
   * 限乘人数
   */
  @TableField("maxCapacity")
  private String maxCapacity;

  /**
   * 完税凭证号码
   */
  @TableField("taxPaidProof")
  private String taxPaidProof;

  /**
   * 消费者身份证号码
   */
  @TableField("identificationId")
  private String identificationId;

  /**
   * 门店号
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 机动销方方电话 （仅机动车使用）
   */
  @TableField("vehicleSellerTel")
  private String vehicleSellerTel;

  /**
   * 机打代码
   */
  @TableField("printedCode")
  private String printedCode;

  /**
   * 机打号码
   */
  @TableField("printedNo")
  private String printedNo;

  /**
   * 主管税务机关名称
   */
  @TableField("chargeTaxAuthorityName")
  private String chargeTaxAuthorityName;

  /**
   * 主管税务机关代码
   */
  @TableField("chargeTaxAuthorityCode")
  private String chargeTaxAuthorityCode;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("manufacturerName", manufacturerName);
      map.put("vehicleType", vehicleType);
      map.put("vehicleBrand", vehicleBrand);
      map.put("productionArea", productionArea);
      map.put("certificationNo", certificationNo);
      map.put("importCertificateNo", importCertificateNo);
      map.put("commodityInspectionNo", commodityInspectionNo);
      map.put("engineNo", engineNo);
      map.put("vehicleNo", vehicleNo);
      map.put("tonnage", tonnage);
      map.put("maxCapacity", maxCapacity);
      map.put("taxPaidProof", taxPaidProof);
      map.put("identificationId", identificationId);
      map.put("storeNo", storeNo);
      map.put("vehicleSellerTel", vehicleSellerTel);
      map.put("printedCode", printedCode);
      map.put("printedNo", printedNo);
      map.put("chargeTaxAuthorityName", chargeTaxAuthorityName);
      map.put("chargeTaxAuthorityCode", chargeTaxAuthorityCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static VehicleInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    VehicleInfo entity = new VehicleInfo();
    if(map.containsKey("manufacturerName")) {
      Object obj = map.get("manufacturerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManufacturerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleType")) {
      Object obj = map.get("vehicleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleBrand")) {
      Object obj = map.get("vehicleBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productionArea")) {
      Object obj = map.get("productionArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductionArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("certificationNo")) {
      Object obj = map.get("certificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCertificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("importCertificateNo")) {
      Object obj = map.get("importCertificateNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commodityInspectionNo")) {
      Object obj = map.get("commodityInspectionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommodityInspectionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("engineNo")) {
      Object obj = map.get("engineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEngineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleNo")) {
      Object obj = map.get("vehicleNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTonnage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("maxCapacity")) {
      Object obj = map.get("maxCapacity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaxCapacity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPaidProof")) {
      Object obj = map.get("taxPaidProof");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPaidProof((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("identificationId")) {
      Object obj = map.get("identificationId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdentificationId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicleSellerTel")) {
      Object obj = map.get("vehicleSellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVehicleSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printedCode")) {
      Object obj = map.get("printedCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintedCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("printedNo")) {
      Object obj = map.get("printedNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrintedNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeTaxAuthorityName")) {
      Object obj = map.get("chargeTaxAuthorityName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeTaxAuthorityName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeTaxAuthorityCode")) {
      Object obj = map.get("chargeTaxAuthorityCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeTaxAuthorityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("manufacturerName")) {
      Object obj = map.get("manufacturerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManufacturerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicleType")) {
      Object obj = map.get("vehicleType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicleBrand")) {
      Object obj = map.get("vehicleBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productionArea")) {
      Object obj = map.get("productionArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductionArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("certificationNo")) {
      Object obj = map.get("certificationNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCertificationNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("importCertificateNo")) {
      Object obj = map.get("importCertificateNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportCertificateNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commodityInspectionNo")) {
      Object obj = map.get("commodityInspectionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCommodityInspectionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("engineNo")) {
      Object obj = map.get("engineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEngineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicleNo")) {
      Object obj = map.get("vehicleNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tonnage")) {
      Object obj = map.get("tonnage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTonnage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("maxCapacity")) {
      Object obj = map.get("maxCapacity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaxCapacity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPaidProof")) {
      Object obj = map.get("taxPaidProof");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPaidProof((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("identificationId")) {
      Object obj = map.get("identificationId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdentificationId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vehicleSellerTel")) {
      Object obj = map.get("vehicleSellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVehicleSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("printedCode")) {
      Object obj = map.get("printedCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrintedCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("printedNo")) {
      Object obj = map.get("printedNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrintedNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeTaxAuthorityName")) {
      Object obj = map.get("chargeTaxAuthorityName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeTaxAuthorityName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chargeTaxAuthorityCode")) {
      Object obj = map.get("chargeTaxAuthorityCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeTaxAuthorityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
