package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * channel
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
public enum Channel {

    DINGDING("dingding", "钉钉"),
    WEB("web", "网页");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Channel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Channel fromCode(String code){
        switch(code) {
            case "dingding":
                return DINGDING;
            case "web":
                return WEB;
            default:
                return null;
        }
    }
}
