package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * doc_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
public enum DocType {

    BIZORDER("bizorder", "业务单"),
    REDLETTER("redletter", "红字信息表"),
    PREINVOICE("preinvoice", "预制发票"),
    SALES_INVOICE("salesInvoice", "销项发票"),
    REDCONFIRMATION("redconfirmation", "红字确认单"),
    PURCHASE_INVOICE("purchaseInvoice", "进项发票"),
    PURCHASE_BIZORDER("purchaseBizorder", "进项业务单"),
    CUSTOMS_PAYMENT("customsPayment", "海关缴款书"),
    SETTLEMENT("settlement", "结算单"),
    COOP_INVOICE("coopInvoice", "协同发票"),
    COOP_RELATION("coopRelation", "协同关系"),
    TAX("tax", "税号"),
    PARTNERS("partners", "客商"),
    LOGISTICS("logistics", "物流"),
    TAXCODE("taxcode", "税编"),
    TITLE("title", "抬头"),
    MESSAGE("message", "通知"),
    UCENTER("ucenter", "用户中心"),
    FILE("file", "文件"),
    RISK("risk", "风险"),
    GOODS("goods", "商品"),
    ONE("one", "统一入住"),
    IMAGE("image", "电子影像"),
    QUEUE("queue", "消息订阅");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocType fromCode(String code){
        switch(code) {
            case "bizorder":
                return BIZORDER;
            case "redletter":
                return REDLETTER;
            case "preinvoice":
                return PREINVOICE;
            case "salesInvoice":
                return SALES_INVOICE;
            case "redconfirmation":
                return REDCONFIRMATION;
            case "purchaseInvoice":
                return PURCHASE_INVOICE;
            case "purchaseBizorder":
                return PURCHASE_BIZORDER;
            case "customsPayment":
                return CUSTOMS_PAYMENT;
            case "settlement":
                return SETTLEMENT;
            case "coopInvoice":
                return COOP_INVOICE;
            case "coopRelation":
                return COOP_RELATION;
            case "tax":
                return TAX;
            case "partners":
                return PARTNERS;
            case "logistics":
                return LOGISTICS;
            case "taxcode":
                return TAXCODE;
            case "title":
                return TITLE;
            case "message":
                return MESSAGE;
            case "ucenter":
                return UCENTER;
            case "file":
                return FILE;
            case "risk":
                return RISK;
            case "goods":
                return GOODS;
            case "one":
                return ONE;
            case "image":
                return IMAGE;
            case "queue":
                return QUEUE;
            default:
                return null;
        }
    }
}
