package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * file_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
public enum FileType {

    PDF("PDF", "PDF"),
    DOCX("DOCX", "DOCX"),
    XLS("XLS", "XLS"),
    TXT("TXT", "TXT"),
    MARKDOWN("MARKDOWN", "MARKDOWN");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code){
        switch(code) {
            case "PDF":
                return PDF;
            case "DOCX":
                return DOCX;
            case "XLS":
                return XLS;
            case "TXT":
                return TXT;
            case "MARKDOWN":
                return MARKDOWN;
            default:
                return null;
        }
    }
}
