package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_from
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
public enum InvoiceFrom {

    SALES_V4("SALES_V4", "4.0 销项"),
    PURCHASE_V4("PURCHASE_V4", "4.0 进项"),
    SALES_V3("SALES_V3", "3.0 销项"),
    PURCHASE_V3("PURCHASE_V3", "3.0 进项"),
    TAXWARE_LF("TAXWARE_LF", "税件发票低频"),
    TAXWARE_CO("TAXWARE_CO", "税件发票归集"),
    IMAGE("IMAGE", "电子影像"),
    PURCHASE_V5("PURCHASE_V5", "4.0 进项（新）"),
    PURCHASE_V4_VERIFY("PURCHASE_V4_VERIFY", "4.0 进项验真"),
    LEDGER("LEDGER", "底账-海关缴款书"),
    PURCHASE_TAXWARE("PURCHASE_TAXWARE", "4.0平台税件"),
    LEDGER_SYNCHRONIZATION("LEDGER_SYNCHRONIZATION", "底账同步"),
    LEDGER_TAX_PAYMENT("LEDGER_TAX_PAYMENT", "底账-代扣代缴完税凭证"),
    LEDGER_APAD("LEDGER_APAD", "底账-农产品加计扣除");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceFrom fromCode(String code){
        switch(code) {
            case "SALES_V4":
                return SALES_V4;
            case "PURCHASE_V4":
                return PURCHASE_V4;
            case "SALES_V3":
                return SALES_V3;
            case "PURCHASE_V3":
                return PURCHASE_V3;
            case "TAXWARE_LF":
                return TAXWARE_LF;
            case "TAXWARE_CO":
                return TAXWARE_CO;
            case "IMAGE":
                return IMAGE;
            case "PURCHASE_V5":
                return PURCHASE_V5;
            case "PURCHASE_V4_VERIFY":
                return PURCHASE_V4_VERIFY;
            case "LEDGER":
                return LEDGER;
            case "PURCHASE_TAXWARE":
                return PURCHASE_TAXWARE;
            case "LEDGER_SYNCHRONIZATION":
                return LEDGER_SYNCHRONIZATION;
            case "LEDGER_TAX_PAYMENT":
                return LEDGER_TAX_PAYMENT;
            case "LEDGER_APAD":
                return LEDGER_APAD;
            default:
                return null;
        }
    }
}
