package com.xforceplus.ultraman.app.openapirapi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ETicketItineraryItem implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 行号
   */
  @TableField("rowNum")
  private Long rowNum;

  /**
   * 始发站
   */
  private String from;

  /**
   * 目的站
   */
  private String to;

  /**
   * 承运人
   */
  private String carrier;

  /**
   * 航段序号
   */
  @TableField("flightSegmentNo")
  private String flightSegmentNo;

  /**
   * 航班号
   */
  @TableField("flightNo")
  private String flightNo;

  /**
   * 座位等级
   */
  @TableField("classOfService")
  private String classOfService;

  /**
   * 承运日期
   */
  @TableField("carrierDate")
  private String carrierDate;

  /**
   * 起飞时间
   */
  @TableField("departureTime")
  private String departureTime;

  /**
   * 客票级别/客票类别
   */
  @TableField("fareBasis")
  private String fareBasis;

  /**
   * 客票生效日期
   */
  @TableField("effectiveDate")
  private String effectiveDate;

  /**
   * 有效截止日期
   */
  private String deadline;

  /**
   * 免费行李
   */
  @TableField("freeWeight")
  private String freeWeight;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 eTicketItinerary
   */
    private Long mainAndDetailRelId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rowNum", rowNum);
      map.put("from", from);
      map.put("to", to);
      map.put("carrier", carrier);
      map.put("flightSegmentNo", flightSegmentNo);
      map.put("flightNo", flightNo);
      map.put("classOfService", classOfService);
      map.put("carrierDate", carrierDate);
      map.put("departureTime", departureTime);
      map.put("fareBasis", fareBasis);
      map.put("effectiveDate", effectiveDate);
      map.put("deadline", deadline);
      map.put("freeWeight", freeWeight);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("mainAndDetailRel.id", mainAndDetailRelId);
      return map;
  }

  public static ETicketItineraryItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ETicketItineraryItem entity = new ETicketItineraryItem();
    if(map.containsKey("rowNum")) {
      Object obj = map.get("rowNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRowNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRowNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRowNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carrier")) {
      Object obj = map.get("carrier");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarrier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flightSegmentNo")) {
      Object obj = map.get("flightSegmentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlightSegmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flightNo")) {
      Object obj = map.get("flightNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlightNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("classOfService")) {
      Object obj = map.get("classOfService");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClassOfService((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carrierDate")) {
      Object obj = map.get("carrierDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarrierDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departureTime")) {
      Object obj = map.get("departureTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartureTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fareBasis")) {
      Object obj = map.get("fareBasis");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFareBasis((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effectiveDate")) {
      Object obj = map.get("effectiveDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEffectiveDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeadline((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeWeight")) {
      Object obj = map.get("freeWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreeWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("mainAndDetailRel.id")) {
        Object obj = map.get("mainAndDetailRel.id");
      if(obj instanceof Long) {
        entity.setMainAndDetailRelId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setMainAndDetailRelId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("rowNum")) {
      Object obj = map.get("rowNum");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRowNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRowNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRowNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("from")) {
      Object obj = map.get("from");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("to")) {
      Object obj = map.get("to");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("carrier")) {
      Object obj = map.get("carrier");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCarrier((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flightSegmentNo")) {
      Object obj = map.get("flightSegmentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlightSegmentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flightNo")) {
      Object obj = map.get("flightNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlightNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("classOfService")) {
      Object obj = map.get("classOfService");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClassOfService((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("carrierDate")) {
      Object obj = map.get("carrierDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCarrierDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("departureTime")) {
      Object obj = map.get("departureTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartureTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fareBasis")) {
      Object obj = map.get("fareBasis");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFareBasis((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("effectiveDate")) {
      Object obj = map.get("effectiveDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEffectiveDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeadline((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freeWeight")) {
      Object obj = map.get("freeWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreeWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("mainAndDetailRel.id")) {
        Object obj = map.get("mainAndDetailRel.id");
        if(obj instanceof Long) {
          this.setMainAndDetailRelId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMainAndDetailRelId(Long.parseLong((String)obj));
        }
      }
  }
}
