package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-21
 */
public enum TaskType {

    VERIFY("VERIFY", "验真"),
    RECOGNITION("RECOGNITION", "识别");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code){
        switch(code) {
            case "VERIFY":
                return VERIFY;
            case "RECOGNITION":
                return RECOGNITION;
            default:
                return null;
        }
    }
}
