package com.xforceplus.ultraman.app.openapirapi.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-12-05
 */
public enum InvoiceSource {

    _9("9", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceSource fromCode(String code){
        switch(code) {
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
