package com.xforceplus.ultraman.app.openapirapi.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.openapirapi.entity.BaseNonVat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-12-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketPlane extends BaseNonVat {


  /**
   * 乘客名称
   */
  @TableField("nameOfPassenger")
  private String nameOfPassenger;

  /**
   * 身份证号码
   */
  @TableField("idNo")
  private String idNo;

  /**
   * 电子客单编号
   */
  @TableField("eTicketNo")
  private String eTicketNo;

  /**
   * 签注
   */
  private String endorsements;

  /**
   * 印刷序号
   */
  @TableField("serialNo")
  private String serialNo;

  /**
   * 提示信息
   */
  private String information;

  /**
   * 销售单位代号
   */
  @TableField("agentCode")
  private String agentCode;

  /**
   * 填开单位
   */
  @TableField("issuedBy")
  private String issuedBy;

  /**
   * 填开日期
   */
  @TableField("dateOfIssue")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dateOfIssue;

  /**
   * 保险费
   */
  private String insurance;

  /**
   * 票价
   */
  private BigDecimal fare;

  /**
   * 民航发展基金
   */
  @TableField("caacDevelopment_fund")
  private BigDecimal caacdevelopmentFund;

  /**
   * 燃油附加费
   */
  @TableField("fuelSurcharge")
  private BigDecimal fuelSurcharge;

  /**
   * 总金额
   */
  private BigDecimal total;

  /**
   * 其他税费
   */
  private BigDecimal tax;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("nameOfPassenger", nameOfPassenger);
      map.put("idNo", idNo);
      map.put("eTicketNo", eTicketNo);
      map.put("endorsements", endorsements);
      map.put("serialNo", serialNo);
      map.put("information", information);
      map.put("agentCode", agentCode);
      map.put("issuedBy", issuedBy);
      map.put("dateOfIssue", BocpGenUtils.toTimestamp(dateOfIssue));
      map.put("insurance", insurance);
      map.put("fare", fare);
      map.put("caacDevelopment_fund", caacdevelopmentFund);
      map.put("fuelSurcharge", fuelSurcharge);
      map.put("total", total);
      map.put("tax", tax);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TicketPlane fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketPlane entity = new TicketPlane();
    entity.setParentByOQSMap(map);
    if(map.containsKey("nameOfPassenger")) {
      Object obj = map.get("nameOfPassenger");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNameOfPassenger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("idNo")) {
      Object obj = map.get("idNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eTicketNo")) {
      Object obj = map.get("eTicketNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setETicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endorsements")) {
      Object obj = map.get("endorsements");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEndorsements((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("information")) {
      Object obj = map.get("information");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentCode")) {
      Object obj = map.get("agentCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAgentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuedBy")) {
      Object obj = map.get("issuedBy");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateOfIssue")) {
      Object obj = map.get("dateOfIssue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDateOfIssue(null);
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInsurance((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFare((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFare(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFare(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFare(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFare(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("caacDevelopment_fund")) {
      Object obj = map.get("caacDevelopment_fund");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCaacdevelopmentFund((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCaacdevelopmentFund(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCaacdevelopmentFund(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCaacdevelopmentFund(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCaacdevelopmentFund(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fuelSurcharge")) {
      Object obj = map.get("fuelSurcharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFuelSurcharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFuelSurcharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFuelSurcharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFuelSurcharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFuelSurcharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("nameOfPassenger")) {
      Object obj = map.get("nameOfPassenger");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameOfPassenger((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("idNo")) {
      Object obj = map.get("idNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eTicketNo")) {
      Object obj = map.get("eTicketNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setETicketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("endorsements")) {
      Object obj = map.get("endorsements");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndorsements((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("information")) {
      Object obj = map.get("information");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInformation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("agentCode")) {
      Object obj = map.get("agentCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAgentCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuedBy")) {
      Object obj = map.get("issuedBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dateOfIssue")) {
      Object obj = map.get("dateOfIssue");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDateOfIssue(null);
      }
    }
    if(map.containsKey("insurance")) {
      Object obj = map.get("insurance");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInsurance((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fare")) {
      Object obj = map.get("fare");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFare((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFare(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFare(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setFare(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFare(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("caacDevelopment_fund")) {
      Object obj = map.get("caacDevelopment_fund");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCaacdevelopmentFund((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCaacdevelopmentFund(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCaacdevelopmentFund(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setCaacdevelopmentFund(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCaacdevelopmentFund(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("fuelSurcharge")) {
      Object obj = map.get("fuelSurcharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFuelSurcharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFuelSurcharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFuelSurcharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setFuelSurcharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFuelSurcharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total")) {
      Object obj = map.get("total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
