package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum InvoiceSource {

    _9("9", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceSource fromCode(String code) {
        return Stream.of(InvoiceSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
