package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 消息类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum MessageType {

    P2P("P2P", "点对点"),
    PUBSUB("PUBSUB", "发布订阅");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MessageType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MessageType fromCode(String code) {
        return Stream.of(MessageType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
