package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 回执状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum ReceiptStatus {

    _1("1", "已回执"),
    _0("0", "待回执");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceiptStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiptStatus fromCode(String code) {
        return Stream.of(ReceiptStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
