package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 服务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum ServiceType {

    AR("AR", "销项"),
    AP("AP", "进项");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ServiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ServiceType fromCode(String code) {
        return Stream.of(ServiceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
