package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum TaskStatus {

    _1("1", "进行中"),
    _2("2", "已停止"),
    _3("3", "已完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskStatus fromCode(String code) {
        return Stream.of(TaskStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
