package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 任务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum TaskType {

    VERIFY("VERIFY", "验真"),
    RECOGNITION("RECOGNITION", "识别"),
    VERIFY_AND_RECOGNITION("VERIFY_AND_RECOGNITION", "识别并验真"),
    AGGREGATE_AND_RECOGNITION("AGGREGATE_AND_RECOGNITION", "文件聚合识别"),
    PDF_TO_IMAGE("PDF_TO_IMAGE", " pdf 转图片"),
    AGGREGATE_AND_RECOGNITION_MULTIPLE("AGGREGATE_AND_RECOGNITION_MULTIPLE", "文件聚合多票识别"),
    AGGREGATE_AND_RECOGNITION_ONE("AGGREGATE_AND_RECOGNITION_ONE", "文件聚合单票识别"),
    PDF_AGGREGATE_AND_RECOGNITION_VERIFY_IMAGE("PDF_AGGREGATE_AND_RECOGNITION_VERIFY_IMAGE", "pdf聚合验签识别转换"),
    PDF_AGGREGATE_AND_RECOGNITION("PDF_AGGREGATE_AND_RECOGNITION", "pdf聚合识别"),
    PDF_AGGREGATE_AND_VERIFY("PDF_AGGREGATE_AND_VERIFY", "pdf聚合验签"),
    PDF_AGGREGATE_AND_IMAGE("PDF_AGGREGATE_AND_IMAGE", "pdf聚合转图片"),
    OPENAPI_PDF_IMAGE("OPENAPI_PDF_IMAGE", "openapi PDF转图片");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code) {
        return Stream.of(TaskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
