package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 三方对账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public enum ThreePartyCheckStatus {

    _0("0", "税局=平台=属地"),
    _1("1", "税局=平台≠属地"),
    _2("2", "税局≠平台=属地"),
    _3("3", "税局≠平台≠属地");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ThreePartyCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ThreePartyCheckStatus fromCode(String code) {
        return Stream.of(ThreePartyCheckStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
