package com.xforceplus.ultraman.app.openapirapi.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * filter_purchase_invoice
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class FilterPurchaseInvoice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 开票日期
   */
  private String dateIssued;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 购方名称
   */
  private String buyerName;
  /**
   * 购方税号
   */
  private String buyerTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 收款人姓名
   */
  private String payee;
  /**
   * 复核人姓名
   */
  private String reviewer;
  /**
   * 开票人姓名
   */
  private String issuer;
  /**
   * 购方公司编号
   */
  private String buyerNo;
  /**
   * 销方公司编号
   */
  private String sellerNo;
  /**
   * 红冲时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reverseTime;
  /**
   * 红字信息表编号
   */
  private String redLetterNumber;
  /**
   * PDF文件地址
   */
  private String pdfUrl;
  /**
   * 购方地址
   */
  private String buyerAddress;
  /**
   * 购方电话
   */
  private String buyerTel;
  /**
   * 购方地址电话
   */
  private String buyerAddressTel;
  /**
   * 购方银行名称
   */
  private String buyerBankName;
  /**
   * 购方银行账号
   */
  private String buyerBankAccount;
  /**
   * 购方银行名称账号
   */
  private String buyerBankInfo;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方地址电话
   */
  private String sellerAddressTel;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 销方银行名称账号
   */
  private String sellerBankInfo;
  /**
   * 发票备注
   */
  private String remark;
  /**
   * 原发票号码
   */
  private String originalInvoiceNo;
  /**
   * 原发票代码
   */
  private String originalInvoiceCode;
  /**
   * 发票类型
   */
  private String invoiceKind;
  /**
   * 发票状态
   */
  private String status;
  /**
   * 发票来源
   */
  private String invoiceSource;
  /**
   * 红冲状态
   */
  private String reverseFlag;
  /**
   * 红蓝票标记
   */
  private String invoiceColor;
  /**
   * 预览地址
   */
  private String viewUrl;
  /**
   * 全电 XML 地址
   */
  private String xmlUrl;
  /**
   * OFD文件地址
   */
  private String ofdUrl;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 账户类型
   */
  private String accountType;
  /**
   * 国税发票来源
   */
  private String taxInvoiceSource;
  /**
   * 业务单号
   */
  private String bizOrderNo;
  /**
   * 二维密文
   */
  private String cipherTextQRCode;
  /**
   * 发票样式
   */
  private String invoiceStyleType;
  /**
   * 是否有销货清单
   */
  private Boolean saleListFileFlag;
  /**
   * 发票特殊类型标识
   */
  private String specialType;
  /**
   * 销方租户代码
   */
  private String sellerTenantCode;
  /**
   * 购方租户代码
   */
  private String buyerTenantCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 认证所属期
   */
  private String authTaxPeriod;
  /**
   * 认证时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTime;
  /**
   * 认证状态
   */
  private String authStatus;
  /**
   * 附件
   */
  private String attachment;
  /**
   * 认证方式
   */
  private String authStyle;
  /**
   * 抵扣用途
   */
  private String authUse;
  /**
   * 认证备注
   */
  private String authRemark;
  /**
   * 被红冲不含税金额
   */
  private BigDecimal reverseAmountWithoutTax;
  /**
   * 被红冲税额
   */
  private BigDecimal reverseTaxAmount;
  /**
   * 被红冲含税金额
   */
  private BigDecimal reverseAmountWithTax;
  /**
   * 有效税额
   */
  private BigDecimal effectiveTaxAmount;
  /**
   * 不抵扣原因
   */
  private String noAuthReason;
  /**
   * 认证业务日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime elConfirmDate;
  /**
   * 底账同步时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime elSyncTime;
  /**
   * 发票匹配操作时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime matchTime;
  /**
   * 匹配金额(含税金额)
   */
  private BigDecimal matchAmount;
  /**
   * 退票状态
   */
  private String retreatStatus;
  /**
   * 合规状态 
   */
  private String complianceStatus;
  /**
   * 签收状态
   */
  private String signForStatus;
  /**
   * 签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signForTime;
  /**
   * 记账状态 
   */
  private String chargeUpStatus;
  /**
   * 记账所属期
   */
  private String chargeUpPeriod;
  /**
   * 记账单号
   */
  private String chargeUpNo;
  /**
   * 付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;
  /**
   * 付款状态  
   */
  private String paymentStatus;
  /**
   * 进转出状态
   */
  private String turnOutStatus;
  /**
   * 进转出金额
   */
  private BigDecimal turnOutAmount;
  /**
   * 进转出所属期
   */
  private String turnOutPeriod;
  /**
   * 审核状态  
   */
  private String auditStatus;
  /**
   * 审核人
   */
  private String auditName;
  /**
   * 审核备注
   */
  private String auditRemark;
  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;
  /**
   * 进转出类型
   */
  private String turnOutType;
  /**
   * 代开标记
   */
  private String agentIssuedFlag;
  /**
   * 代开名称
   */
  private String agentIssuedName;
  /**
   * 代开纳税人识别号
   */
  private String agentIssuedTaxNo;
  /**
   * 扩展字段1
   */
  private String ext1;
  /**
   * 扩展字段2
   */
  private String ext2;
  /**
   * 扩展字段3
   */
  private String ext3;
  /**
   * 扩展字段4
   */
  private String ext4;
  /**
   * 扩展字段5
   */
  private String ext5;
  /**
   * 扩展字段6
   */
  private String ext6;
  /**
   * 扩展字段7
   */
  private String ext7;
  /**
   * 扩展字段8
   */
  private String ext8;
  /**
   * 扩展字段9
   */
  private String ext9;
  /**
   * 扩展字段10
   */
  private String ext10;
  /**
   * 扩展字段11
   */
  private String ext11;
  /**
   * 扩展字段12
   */
  private String ext12;
  /**
   * 发票匹配状态 
   */
  private String matchStatus;
  /**
   * 退票备注
   */
  private String retreatRemark;
  /**
   * 业务标签
   */
  private String businessTag;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 验真状态
   */
  private String veriStatus;
  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;
  /**
   * 验真状态
   */
  private String verifyStatus;
  /**
   * 特殊发票标志
   */
  private String specialInvoiceFlag;
  /**
   * 系统来源
   */
  private String source;
  /**
   * 查验人
   */
  private String verifyUserName;
  /**
   * 退票操作时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime retreatTime;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("dateIssued", dateIssued);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("machineCode", machineCode);
      map.put("checkCode", checkCode);
      map.put("cipherText", cipherText);
      map.put("payee", payee);
      map.put("reviewer", reviewer);
      map.put("issuer", issuer);
      map.put("buyerNo", buyerNo);
      map.put("sellerNo", sellerNo);
      map.put("reverseTime", BocpGenUtils.toTimestamp(reverseTime));
      map.put("redLetterNumber", redLetterNumber);
      map.put("pdfUrl", pdfUrl);
      map.put("buyerAddress", buyerAddress);
      map.put("buyerTel", buyerTel);
      map.put("buyerAddressTel", buyerAddressTel);
      map.put("buyerBankName", buyerBankName);
      map.put("buyerBankAccount", buyerBankAccount);
      map.put("buyerBankInfo", buyerBankInfo);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddressTel", sellerAddressTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("remark", remark);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("invoiceKind", invoiceKind);
      map.put("status", status);
      map.put("invoiceSource", invoiceSource);
      map.put("reverseFlag", reverseFlag);
      map.put("invoiceColor", invoiceColor);
      map.put("viewUrl", viewUrl);
      map.put("xmlUrl", xmlUrl);
      map.put("ofdUrl", ofdUrl);
      map.put("taxRate", taxRate);
      map.put("accountType", accountType);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("bizOrderNo", bizOrderNo);
      map.put("cipherTextQRCode", cipherTextQRCode);
      map.put("invoiceStyleType", invoiceStyleType);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("specialType", specialType);
      map.put("sellerTenantCode", sellerTenantCode);
      map.put("buyerTenantCode", buyerTenantCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("authTaxPeriod", authTaxPeriod);
      map.put("authTime", BocpGenUtils.toTimestamp(authTime));
      map.put("authStatus", authStatus);
      map.put("attachment", attachment);
      map.put("authStyle", authStyle);
      map.put("authUse", authUse);
      map.put("authRemark", authRemark);
      map.put("reverseAmountWithoutTax", reverseAmountWithoutTax);
      map.put("reverseTaxAmount", reverseTaxAmount);
      map.put("reverseAmountWithTax", reverseAmountWithTax);
      map.put("effectiveTaxAmount", effectiveTaxAmount);
      map.put("noAuthReason", noAuthReason);
      map.put("elConfirmDate", BocpGenUtils.toTimestamp(elConfirmDate));
      map.put("elSyncTime", BocpGenUtils.toTimestamp(elSyncTime));
      map.put("matchTime", BocpGenUtils.toTimestamp(matchTime));
      map.put("matchAmount", matchAmount);
      map.put("retreatStatus", retreatStatus);
      map.put("complianceStatus", complianceStatus);
      map.put("signForStatus", signForStatus);
      map.put("signForTime", BocpGenUtils.toTimestamp(signForTime));
      map.put("chargeUpStatus", chargeUpStatus);
      map.put("chargeUpPeriod", chargeUpPeriod);
      map.put("chargeUpNo", chargeUpNo);
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("paymentStatus", paymentStatus);
      map.put("turnOutStatus", turnOutStatus);
      map.put("turnOutAmount", turnOutAmount);
      map.put("turnOutPeriod", turnOutPeriod);
      map.put("auditStatus", auditStatus);
      map.put("auditName", auditName);
      map.put("auditRemark", auditRemark);
      map.put("auditTime", BocpGenUtils.toTimestamp(auditTime));
      map.put("turnOutType", turnOutType);
      map.put("agentIssuedFlag", agentIssuedFlag);
      map.put("agentIssuedName", agentIssuedName);
      map.put("agentIssuedTaxNo", agentIssuedTaxNo);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("matchStatus", matchStatus);
      map.put("retreatRemark", retreatRemark);
      map.put("businessTag", businessTag);
      map.put("invoiceType", invoiceType);
      map.put("veriStatus", veriStatus);
      map.put("checkTime", BocpGenUtils.toTimestamp(checkTime));
      map.put("verifyStatus", verifyStatus);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      map.put("source", source);
      map.put("verifyUserName", verifyUserName);
      map.put("retreatTime", BocpGenUtils.toTimestamp(retreatTime));

      return map;
  }

  public static FilterPurchaseInvoice fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    FilterPurchaseInvoice entity = new FilterPurchaseInvoice();

    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssued")) {
      Object obj = map.get("dateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerNo")) {
      Object obj = map.get("buyerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReverseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReverseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReverseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReverseTime(null);
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddressTel")) {
      Object obj = map.get("buyerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankInfo")) {
      Object obj = map.get("buyerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddressTel")) {
      Object obj = map.get("sellerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSource")) {
      Object obj = map.get("invoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseFlag")) {
      Object obj = map.get("reverseFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewUrl")) {
      Object obj = map.get("viewUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setViewUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextQRCode")) {
      Object obj = map.get("cipherTextQRCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherTextQRCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStyleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSaleListFileFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleListFileFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialType")) {
      Object obj = map.get("specialType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTenantCode")) {
      Object obj = map.get("buyerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTaxPeriod")) {
      Object obj = map.get("authTaxPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTime")) {
      Object obj = map.get("authTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTime(null);
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment")) {
      Object obj = map.get("attachment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttachment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStyle")) {
      Object obj = map.get("authStyle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authUse")) {
      Object obj = map.get("authUse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRemark")) {
      Object obj = map.get("authRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseAmountWithoutTax")) {
      Object obj = map.get("reverseAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReverseAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReverseAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReverseAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReverseAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReverseAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reverseTaxAmount")) {
      Object obj = map.get("reverseTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReverseTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReverseTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReverseTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReverseTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReverseTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reverseAmountWithTax")) {
      Object obj = map.get("reverseAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReverseAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReverseAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReverseAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReverseAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReverseAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("effectiveTaxAmount")) {
      Object obj = map.get("effectiveTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("noAuthReason")) {
      Object obj = map.get("noAuthReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elConfirmDate")) {
      Object obj = map.get("elConfirmDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElConfirmDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setElConfirmDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setElConfirmDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setElConfirmDate(null);
      }
    }
    if(map.containsKey("elSyncTime")) {
      Object obj = map.get("elSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setElSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setElSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setElSyncTime(null);
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMatchTime(null);
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complianceStatus")) {
      Object obj = map.get("complianceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signForStatus")) {
      Object obj = map.get("signForStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signForTime")) {
      Object obj = map.get("signForTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignForTime(null);
      }
    }
    if(map.containsKey("chargeUpStatus")) {
      Object obj = map.get("chargeUpStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpPeriod")) {
      Object obj = map.get("chargeUpPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpNo")) {
      Object obj = map.get("chargeUpNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutStatus")) {
      Object obj = map.get("turnOutStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutAmount")) {
      Object obj = map.get("turnOutAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTurnOutAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTurnOutAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTurnOutAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTurnOutAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTurnOutAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("turnOutPeriod")) {
      Object obj = map.get("turnOutPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditName")) {
      Object obj = map.get("auditName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditRemark")) {
      Object obj = map.get("auditRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditTime")) {
      Object obj = map.get("auditTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("turnOutType")) {
      Object obj = map.get("turnOutType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTurnOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentIssuedFlag")) {
      Object obj = map.get("agentIssuedFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentIssuedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentIssuedName")) {
      Object obj = map.get("agentIssuedName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentIssuedName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentIssuedTaxNo")) {
      Object obj = map.get("agentIssuedTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentIssuedTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatRemark")) {
      Object obj = map.get("retreatRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTag")) {
      Object obj = map.get("businessTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkTime")) {
      Object obj = map.get("checkTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("verifyStatus")) {
      Object obj = map.get("verifyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verifyUserName")) {
      Object obj = map.get("verifyUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetreatTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setRetreatTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetreatTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRetreatTime(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssued")) {
      Object obj = map.get("dateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIssuer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerNo")) {
      Object obj = map.get("buyerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReverseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReverseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReverseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReverseTime(null);
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddressTel")) {
      Object obj = map.get("buyerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankInfo")) {
      Object obj = map.get("buyerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddressTel")) {
      Object obj = map.get("sellerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSource")) {
      Object obj = map.get("invoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseFlag")) {
      Object obj = map.get("reverseFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReverseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewUrl")) {
      Object obj = map.get("viewUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setViewUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextQRCode")) {
      Object obj = map.get("cipherTextQRCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherTextQRCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceStyleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setSaleListFileFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleListFileFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialType")) {
      Object obj = map.get("specialType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTenantCode")) {
      Object obj = map.get("buyerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTaxPeriod")) {
      Object obj = map.get("authTaxPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTime")) {
      Object obj = map.get("authTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthTime(null);
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment")) {
      Object obj = map.get("attachment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAttachment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStyle")) {
      Object obj = map.get("authStyle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authUse")) {
      Object obj = map.get("authUse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRemark")) {
      Object obj = map.get("authRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseAmountWithoutTax")) {
      Object obj = map.get("reverseAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReverseAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReverseAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReverseAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReverseAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReverseAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reverseTaxAmount")) {
      Object obj = map.get("reverseTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReverseTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReverseTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReverseTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReverseTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReverseTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reverseAmountWithTax")) {
      Object obj = map.get("reverseAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setReverseAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setReverseAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setReverseAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReverseAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setReverseAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("effectiveTaxAmount")) {
      Object obj = map.get("effectiveTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("noAuthReason")) {
      Object obj = map.get("noAuthReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elConfirmDate")) {
      Object obj = map.get("elConfirmDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setElConfirmDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setElConfirmDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setElConfirmDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setElConfirmDate(null);
      }
    }
    if(map.containsKey("elSyncTime")) {
      Object obj = map.get("elSyncTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setElSyncTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setElSyncTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setElSyncTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setElSyncTime(null);
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setMatchTime(null);
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complianceStatus")) {
      Object obj = map.get("complianceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signForStatus")) {
      Object obj = map.get("signForStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signForTime")) {
      Object obj = map.get("signForTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSignForTime(null);
      }
    }
    if(map.containsKey("chargeUpStatus")) {
      Object obj = map.get("chargeUpStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpPeriod")) {
      Object obj = map.get("chargeUpPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeUpPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chargeUpNo")) {
      Object obj = map.get("chargeUpNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("paymentStatus")) {
      Object obj = map.get("paymentStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutStatus")) {
      Object obj = map.get("turnOutStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turnOutAmount")) {
      Object obj = map.get("turnOutAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTurnOutAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTurnOutAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTurnOutAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTurnOutAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTurnOutAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("turnOutPeriod")) {
      Object obj = map.get("turnOutPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTurnOutPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditName")) {
      Object obj = map.get("auditName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditRemark")) {
      Object obj = map.get("auditRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditTime")) {
      Object obj = map.get("auditTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("turnOutType")) {
      Object obj = map.get("turnOutType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTurnOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentIssuedFlag")) {
      Object obj = map.get("agentIssuedFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentIssuedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentIssuedName")) {
      Object obj = map.get("agentIssuedName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentIssuedName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agentIssuedTaxNo")) {
      Object obj = map.get("agentIssuedTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAgentIssuedTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatRemark")) {
      Object obj = map.get("retreatRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTag")) {
      Object obj = map.get("businessTag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkTime")) {
      Object obj = map.get("checkTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckTime(null);
      }
    }
    if(map.containsKey("verifyStatus")) {
      Object obj = map.get("verifyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verifyUserName")) {
      Object obj = map.get("verifyUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVerifyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setRetreatTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setRetreatTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setRetreatTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setRetreatTime(null);
      }
    }
  }
}
