package com.xforceplus.ultraman.app.openapirapi.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_send_statistic
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceSendStatistic implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 账户类型
   */
  private String accountType;
  /**
   * 年份
   */
  private String year;
  /**
   * 月份
   */
  private String month;
  /**
   * 税号
   */
  private String taxNo;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 发送发票数量
   */
  private String sendNum;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 税件低频统计
   */
  private String numberFromTaxwareLR;
  /**
   * 税件归集统计
   */
  private String numberFromTaxwareCO;
  /**
   * 4.0 进项统计局
   */
  private String numberFromPurchaseV4;
  /**
   * 4.0 销项统计
   */
  private String numberFromSalesV4;
  /**
   * 电子影像统计
   */
  private String numberFromImage;
  /**
   * 集成平台统计
   */
  private String numberFromIP;
  /**
   * 公司名称
   */
  private String companyName;
  /**
   * 低频对账状态
   */
  private String lfStatus;
  /**
   * openapi归集统计
   */
  private String sendNumTaxwareCO;
  /**
   * openapi4.0进项统计
   */
  private String sendNumPurchaseV4;
  /**
   * openapi低频统计
   */
  private String sendNumTaxwareLR;
  /**
   * openapi电子影像
   */
  private String sendNumFromImage;
  /**
   * openapi4.0销项统计
   */
  private String sendNumFromSalesV4;
  /**
   * 归集对账状态
   */
  private String taxWareCoStatus;
  /**
   * 归集税局发票数量
   */
  private String taxCountCO;
  /**
   * 归集税局最新同步时间
   */
  private String synTimeCO;
  /**
   * 低频最新同步时间
   */
  private String lastOverDateLR;
  /**
   * 属地收到发票数量
   */
  private String ackNum;
  /**
   * 对账状态
   */
  private String status;
  /**
   * 最大开票日期
   */
  private String lastDateIssued;
  /**
   * 发票明细是否一致
   */
  private String invoiceItemConsistencyFlag;
  /**
   * 三方对账状态
   */
  private String threePartyCheckStatus;
  /**
   * 税局数量
   */
  private String taxCount;
  /**
   * 税局最新同步时间
   */
  private String syncTime;
  /**
   * 税局最新同步时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime syncDateTime;
  /**
   * 税局数量bak
   */
  private String taxCountBak;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("tenantCode", tenantCode);
      map.put("accountType", accountType);
      map.put("year", year);
      map.put("month", month);
      map.put("taxNo", taxNo);
      map.put("invoiceType", invoiceType);
      map.put("sendNum", sendNum);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("numberFromTaxwareLR", numberFromTaxwareLR);
      map.put("numberFromTaxwareCO", numberFromTaxwareCO);
      map.put("numberFromPurchaseV4", numberFromPurchaseV4);
      map.put("numberFromSalesV4", numberFromSalesV4);
      map.put("numberFromImage", numberFromImage);
      map.put("numberFromIP", numberFromIP);
      map.put("companyName", companyName);
      map.put("lfStatus", lfStatus);
      map.put("sendNumTaxwareCO", sendNumTaxwareCO);
      map.put("sendNumPurchaseV4", sendNumPurchaseV4);
      map.put("sendNumTaxwareLR", sendNumTaxwareLR);
      map.put("sendNumFromImage", sendNumFromImage);
      map.put("sendNumFromSalesV4", sendNumFromSalesV4);
      map.put("taxWareCoStatus", taxWareCoStatus);
      map.put("taxCountCO", taxCountCO);
      map.put("synTimeCO", synTimeCO);
      map.put("lastOverDateLR", lastOverDateLR);
      map.put("ackNum", ackNum);
      map.put("status", status);
      map.put("lastDateIssued", lastDateIssued);
      map.put("invoiceItemConsistencyFlag", invoiceItemConsistencyFlag);
      map.put("threePartyCheckStatus", threePartyCheckStatus);
      map.put("taxCount", taxCount);
      map.put("syncTime", syncTime);
      map.put("syncDateTime", BocpGenUtils.toTimestamp(syncDateTime));
      map.put("taxCountBak", taxCountBak);

      return map;
  }

  public static InvoiceSendStatistic fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceSendStatistic entity = new InvoiceSendStatistic();

    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNum")) {
      Object obj = map.get("sendNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromTaxwareLR")) {
      Object obj = map.get("numberFromTaxwareLR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNumberFromTaxwareLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromTaxwareCO")) {
      Object obj = map.get("numberFromTaxwareCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNumberFromTaxwareCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromPurchaseV4")) {
      Object obj = map.get("numberFromPurchaseV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNumberFromPurchaseV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromSalesV4")) {
      Object obj = map.get("numberFromSalesV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNumberFromSalesV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromImage")) {
      Object obj = map.get("numberFromImage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNumberFromImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromIP")) {
      Object obj = map.get("numberFromIP");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNumberFromIP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lfStatus")) {
      Object obj = map.get("lfStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLfStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumTaxwareCO")) {
      Object obj = map.get("sendNumTaxwareCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendNumTaxwareCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumPurchaseV4")) {
      Object obj = map.get("sendNumPurchaseV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendNumPurchaseV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumTaxwareLR")) {
      Object obj = map.get("sendNumTaxwareLR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendNumTaxwareLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumFromImage")) {
      Object obj = map.get("sendNumFromImage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendNumFromImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumFromSalesV4")) {
      Object obj = map.get("sendNumFromSalesV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSendNumFromSalesV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxWareCoStatus")) {
      Object obj = map.get("taxWareCoStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxWareCoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCountCO")) {
      Object obj = map.get("taxCountCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCountCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("synTimeCO")) {
      Object obj = map.get("synTimeCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSynTimeCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastOverDateLR")) {
      Object obj = map.get("lastOverDateLR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastOverDateLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ackNum")) {
      Object obj = map.get("ackNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAckNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastDateIssued")) {
      Object obj = map.get("lastDateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemConsistencyFlag")) {
      Object obj = map.get("invoiceItemConsistencyFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceItemConsistencyFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threePartyCheckStatus")) {
      Object obj = map.get("threePartyCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThreePartyCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCount")) {
      Object obj = map.get("taxCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncTime")) {
      Object obj = map.get("syncTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncDateTime")) {
      Object obj = map.get("syncDateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSyncDateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSyncDateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSyncDateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSyncDateTime(null);
      }
    }
    if(map.containsKey("taxCountBak")) {
      Object obj = map.get("taxCountBak");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxCountBak((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxNo")) {
      Object obj = map.get("taxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNum")) {
      Object obj = map.get("sendNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromTaxwareLR")) {
      Object obj = map.get("numberFromTaxwareLR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNumberFromTaxwareLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromTaxwareCO")) {
      Object obj = map.get("numberFromTaxwareCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNumberFromTaxwareCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromPurchaseV4")) {
      Object obj = map.get("numberFromPurchaseV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNumberFromPurchaseV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromSalesV4")) {
      Object obj = map.get("numberFromSalesV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNumberFromSalesV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromImage")) {
      Object obj = map.get("numberFromImage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNumberFromImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numberFromIP")) {
      Object obj = map.get("numberFromIP");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setNumberFromIP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lfStatus")) {
      Object obj = map.get("lfStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLfStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumTaxwareCO")) {
      Object obj = map.get("sendNumTaxwareCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendNumTaxwareCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumPurchaseV4")) {
      Object obj = map.get("sendNumPurchaseV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendNumPurchaseV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumTaxwareLR")) {
      Object obj = map.get("sendNumTaxwareLR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendNumTaxwareLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumFromImage")) {
      Object obj = map.get("sendNumFromImage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendNumFromImage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sendNumFromSalesV4")) {
      Object obj = map.get("sendNumFromSalesV4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSendNumFromSalesV4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxWareCoStatus")) {
      Object obj = map.get("taxWareCoStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxWareCoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCountCO")) {
      Object obj = map.get("taxCountCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxCountCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("synTimeCO")) {
      Object obj = map.get("synTimeCO");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSynTimeCO((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastOverDateLR")) {
      Object obj = map.get("lastOverDateLR");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastOverDateLR((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ackNum")) {
      Object obj = map.get("ackNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAckNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastDateIssued")) {
      Object obj = map.get("lastDateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceItemConsistencyFlag")) {
      Object obj = map.get("invoiceItemConsistencyFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceItemConsistencyFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("threePartyCheckStatus")) {
      Object obj = map.get("threePartyCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setThreePartyCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxCount")) {
      Object obj = map.get("taxCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncTime")) {
      Object obj = map.get("syncTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncDateTime")) {
      Object obj = map.get("syncDateTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSyncDateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSyncDateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSyncDateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSyncDateTime(null);
      }
    }
    if(map.containsKey("taxCountBak")) {
      Object obj = map.get("taxCountBak");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxCountBak((String)obj);
        }
      } else{
      }
    }
  }
}
