package com.xforceplus.ultraman.app.openapirapi.metadata.validator;

import com.xforceplus.ultraman.app.openapirapi.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.openapirapi.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(TaskStatus.class)) {
            isValid = null != TaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = null != TaskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = null != AccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = null != PricingMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessListStatus.class)) {
            isValid = null != BusinessListStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessListStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessListDetailStatus.class)) {
            isValid = null != BusinessListDetailStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessListDetailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageStatus.class)) {
            isValid = null != MessageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptStatus.class)) {
            isValid = null != ReceiptStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiptStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = null != InvoiceKind.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(ServiceType.class)) {
            isValid = null != ServiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ServiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(EventType.class)) {
            isValid = null != EventType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EventType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = null != InvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = null != ReverseStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = null != AuthStyle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = null != AuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = null != InvoiceStyleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = null != SpecialType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = null != RetreatStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = null != ComplianceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = null != TurnOutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = null != TurnOutType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AgentIssuedFlag.class)) {
            isValid = null != AgentIssuedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AgentIssuedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChangedType.class)) {
            isValid = null != ChangedType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChangedType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceFrom.class)) {
            isValid = null != InvoiceFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageInvoiceType.class)) {
            isValid = null != ImageInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = null != HandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.class)) {
            isValid = null != ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.class.getSimpleName());
            }
        }
        if(clazz.equals(Status9zZZHbnxmNhxh4ANLCCfLf.class)) {
            isValid = null != Status9zZZHbnxmNhxh4ANLCCfLf.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status9zZZHbnxmNhxh4ANLCCfLf.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus9uwAe7Si7QbsvDxzTKxKEM.class)) {
            isValid = null != HandleStatus9uwAe7Si7QbsvDxzTKxKEM.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatus9uwAe7Si7QbsvDxzTKxKEM.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageInvoiceType6QEYJAQxTLP6EHAjdkfM3K.class)) {
            isValid = null != ImageInvoiceType6QEYJAQxTLP6EHAjdkfM3K.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageInvoiceType6QEYJAQxTLP6EHAjdkfM3K.class.getSimpleName());
            }
        }
        if(clazz.equals(Status7TbKCZKb9cSPNEQCpVmvES.class)) {
            isValid = null != Status7TbKCZKb9cSPNEQCpVmvES.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status7TbKCZKb9cSPNEQCpVmvES.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatusSffLxjGTcLfWeoMBKSd3Y7.class)) {
            isValid = null != HandleStatusSffLxjGTcLfWeoMBKSd3Y7.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HandleStatusSffLxjGTcLfWeoMBKSd3Y7.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = null != DataSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketStatus.class)) {
            isValid = null != TicketStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TicketStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LfStatus.class)) {
            isValid = null != LfStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LfStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatisticCheckStatus.class)) {
            isValid = null != InvoiceStatisticCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatisticCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceItemConsistencyFlag.class)) {
            isValid = null != InvoiceItemConsistencyFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceItemConsistencyFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ManageStatus.class)) {
            isValid = null != ManageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ThreePartyCheckStatus.class)) {
            isValid = null != ThreePartyCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ThreePartyCheckStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
