package com.xforceplus.ultraman.app.openapirapi.metadata.validator;

import com.xforceplus.ultraman.app.openapirapi.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.openapirapi.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-10-27
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(TaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PricingMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessListStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessListStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessListStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessListDetailStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessListDetailStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessListDetailStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiptStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiptStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(ServiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ServiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ServiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(EventType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EventType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EventType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReverseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStyle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStyleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetreatStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ComplianceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AgentIssuedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AgentIssuedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AgentIssuedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChangedType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChangedType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChangedType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.class.getSimpleName());
            }
        }
        if(clazz.equals(Status9zZZHbnxmNhxh4ANLCCfLf.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status9zZZHbnxmNhxh4ANLCCfLf.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status9zZZHbnxmNhxh4ANLCCfLf.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatus9uwAe7Si7QbsvDxzTKxKEM.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatus9uwAe7Si7QbsvDxzTKxKEM.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatus9uwAe7Si7QbsvDxzTKxKEM.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageInvoiceType6QEYJAQxTLP6EHAjdkfM3K.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageInvoiceType6QEYJAQxTLP6EHAjdkfM3K.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageInvoiceType6QEYJAQxTLP6EHAjdkfM3K.class.getSimpleName());
            }
        }
        if(clazz.equals(Status7TbKCZKb9cSPNEQCpVmvES.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status7TbKCZKb9cSPNEQCpVmvES.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status7TbKCZKb9cSPNEQCpVmvES.class.getSimpleName());
            }
        }
        if(clazz.equals(HandleStatusSffLxjGTcLfWeoMBKSd3Y7.class)) {
            isValid = vals.stream()
                    .filter(val -> null != HandleStatusSffLxjGTcLfWeoMBKSd3Y7.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, HandleStatusSffLxjGTcLfWeoMBKSd3Y7.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(TicketStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TicketStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TicketStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LfStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LfStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LfStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatisticCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatisticCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatisticCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceItemConsistencyFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceItemConsistencyFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceItemConsistencyFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ManageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ManageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ThreePartyCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ThreePartyCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ThreePartyCheckStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
