package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_list_detail_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum BusinessListDetailStatus {

    _1("1", "正常"),
    _2("2", "作废"),
    _3("3", "开票已提交"),
    _4("4", "已开票"),
    _5("5", "已退回"),
    _9("9", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessListDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessListDetailStatus fromCode(String code) {
        return Stream.of(BusinessListDetailStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
