package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_list_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum BusinessListStatus {

    _1("1", "正常"),
    _2("2", "作废"),
    _9("9", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessListStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessListStatus fromCode(String code) {
        return Stream.of(BusinessListStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
