package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * changed_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum ChangedType {

    _1("1", "新增"),
    _2("2", "更新"),
    _3("3", "无变化");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChangedType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChangedType fromCode(String code) {
        return Stream.of(ChangedType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
