package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * event_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum EventType {

    TAXWARE_INVOICE_SYNC_EVENT("taxware-invoice-sync-event", "进销项发票低频同步"),
    TAXWARE_INVOICE_COLLECTION_SYNC_EVENT("taxware-invoice-collection-sync-event", "发票归集同步");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EventType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EventType fromCode(String code) {
        return Stream.of(EventType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
