package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * imageinvoicetype_4lbycjcfleyahrzeahjubi
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi {

    T("t", "火车票"),
    TAXI("taxi", "出租车票"),
    QUOTA("quota", "定额发票"),
    VS("vs", "二手车发票"),
    IM("im", "通用机打发票"),
    TOLL("toll", "过路费发票"),
    P("p", "飞机票"),
    BUS("bus", "客运公交票"),
    OTHER("other", "其他发票"),
    CT("ct", "增值税电子普通发票（通行费) "),
    PAYMENT("payment", "海关缴款书"),
    CDF("cdf", "海关货物报关单"),
    FC("fc", "财政票据"),
    FCE("fce", "通用财政票据（电子）"),
    MOE("moe", "医疗门诊收费票据（电子）"),
    MHE("mhe", "医疗住院收费票据（电子）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi fromCode(String code) {
        return Stream.of(ImageInvoiceType4LbYcJCfLeyaHrzEAhjUBi.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
