package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_item_consistency_flag
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum InvoiceItemConsistencyFlag {

    _0("0", "一致"),
    _1("1", "不一致");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceItemConsistencyFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceItemConsistencyFlag fromCode(String code) {
        return Stream.of(InvoiceItemConsistencyFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
