package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_statistic_check_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum InvoiceStatisticCheckStatus {

    _1("1", "对账通过"),
    _2("2", "对账中"),
    _3("3", "对账不一致"),
    _4("4", "未开通");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatisticCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatisticCheckStatus fromCode(String code) {
        return Stream.of(InvoiceStatisticCheckStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
