package com.xforceplus.ultraman.app.openapirapi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * message_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
public enum MessageStatus {

    _1("1", "成功"),
    _0("0", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MessageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MessageStatus fromCode(String code) {
        return Stream.of(MessageStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
