package com.xforceplus.ultraman.app.openapirapi.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * base_standard_invoice_main
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BaseStandardInvoiceMain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 开票日期
   */
  private String dateIssued;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 购方名称
   */
  private String buyerName;
  /**
   * 购方税号
   */
  private String buyerTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 收款人姓名
   */
  private String payee;
  /**
   * 复核人姓名
   */
  private String reviewer;
  /**
   * 开票人姓名
   */
  private String issuer;
  /**
   * 购方公司编号
   */
  private String buyerNo;
  /**
   * 销方公司编号
   */
  private String sellerNo;
  /**
   * 红冲时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reverseTime;
  /**
   * 红字信息表编号
   */
  private String redLetterNumber;
  /**
   * PDF文件地址
   */
  private String pdfUrl;
  /**
   * 购方地址
   */
  private String buyerAddress;
  /**
   * 购方电话
   */
  private String buyerTel;
  /**
   * 购方地址电话
   */
  private String buyerAddressTel;
  /**
   * 购方银行名称
   */
  private String buyerBankName;
  /**
   * 购方银行账号
   */
  private String buyerBankAccount;
  /**
   * 购方银行名称账号
   */
  private String buyerBankInfo;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方地址电话
   */
  private String sellerAddressTel;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 销方银行名称账号
   */
  private String sellerBankInfo;
  /**
   * 发票备注
   */
  private String remark;
  /**
   * 原发票号码
   */
  private String originalInvoiceNo;
  /**
   * 原发票代码
   */
  private String originalInvoiceCode;
  /**
   * 发票类型
   */
  private String invoiceKind;
  /**
   * 发票状态
   */
  private String status;
  /**
   * 发票来源
   */
  private String invoiceSource;
  /**
   * 红冲状态
   */
  private String reverseFlag;
  /**
   * 红蓝票标记
   */
  private String invoiceColor;
  /**
   * 预览地址
   */
  private String viewUrl;
  /**
   * 全电 XML 地址
   */
  private String xmlUrl;
  /**
   * OFD文件地址
   */
  private String ofdUrl;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 账户类型
   */
  private String accountType;
  /**
   * 国税发票来源
   */
  private String taxInvoiceSource;
  /**
   * 业务单号
   */
  private String bizOrderNo;
  /**
   * 二维密文
   */
  private String cipherTextQRCode;
  /**
   * 发票样式
   */
  private String invoiceStyleType;
  /**
   * 是否有销货清单
   */
  private Boolean saleListFileFlag;
  /**
   * 发票特殊类型标识
   */
  private String specialType;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 销方租户代码
   */
  private String sellerTenantCode;
  /**
   * 购方租户代码
   */
  private String buyerTenantCode;
  /**
   * 数据来源
   */
  private String dataSource;
  /**
   * 是否被过滤
   */
  private Boolean filterFlag;
  /**
   * 特殊发票标志
   */
  private String specialInvoiceFlag;
  /**
   * 开票日期年份
   */
  private String dateIssuedYear;
  /**
   * 开票日期月份
   */
  private String dateIssuedMonth;
  /**
   * 增值税使用标签
   */
  private String vatUsageLabel;
  /**
   * 发票税控风险类型状态
   */
  private String riskStatus;
  /**
   * 入账时间
   */
  private String entryTime;
  /**
   * 入账状态
   */
  private String entryStatus;
  /**
   * 消费税使用所属期
   */
  private String consumptionTaxCheckPeriod;
  /**
   * 上次发票消息的更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastUpdateTime;
  /**
   * 属地是否已经收到此发票
   */
  private Boolean ack;
  /**
   * 属地确认时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ackTime;
  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dateIssuedTime;
  /**
   * 增值税勾选所属期
   */
  private String vatCheckPeriod;
  /**
   * 消费税使用状态
   */
  private String consumptionTaxCheckLabel;
  /**
   * 付款人
   */
  private String cashierName;
  /**
   * 审核人
   */
  private String checkerName;
  /**
   * 国税最新一次同步时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime synTime;
  /**
   * 红冲列表
   */
  private String reverseList;
  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;
  /**
   * 发票明细数量
   */
  private Long invoiceDetailSize;
  /**
   * 含税金额是否一致
   */
  private Boolean amountWithTaxConsistencyFlag;
  /**
   * 上一次发票类型
   */
  private String lastInvoiceType;
  /**
   * 修改后的税号
   */
  private String changeTaxNo;
  /**
   * 摘要码
   */
  private String digestCode;
  /**
   * 检验码
   */
  private String checkKey;
  /**
   * 最初发票类型
   */
  private String firstInvoiceType;
  /**
   * 发票类型是否发生过修改
   */
  private Boolean hasChangeInvoiceType;
  /**
   * 是否删除
   */
  private Boolean deleteStatus;

  /**
   * 对一关联关系 关联对象 vehicleInfo
   */
  private Long vehicleInfoId;

  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("dateIssued", dateIssued);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("machineCode", machineCode);
      map.put("checkCode", checkCode);
      map.put("cipherText", cipherText);
      map.put("payee", payee);
      map.put("reviewer", reviewer);
      map.put("issuer", issuer);
      map.put("buyerNo", buyerNo);
      map.put("sellerNo", sellerNo);
      map.put("reverseTime", BocpGenUtils.toTimestamp(reverseTime));
      map.put("redLetterNumber", redLetterNumber);
      map.put("pdfUrl", pdfUrl);
      map.put("buyerAddress", buyerAddress);
      map.put("buyerTel", buyerTel);
      map.put("buyerAddressTel", buyerAddressTel);
      map.put("buyerBankName", buyerBankName);
      map.put("buyerBankAccount", buyerBankAccount);
      map.put("buyerBankInfo", buyerBankInfo);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddressTel", sellerAddressTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("remark", remark);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("invoiceKind", invoiceKind);
      map.put("status", status);
      map.put("invoiceSource", invoiceSource);
      map.put("reverseFlag", reverseFlag);
      map.put("invoiceColor", invoiceColor);
      map.put("viewUrl", viewUrl);
      map.put("xmlUrl", xmlUrl);
      map.put("ofdUrl", ofdUrl);
      map.put("taxRate", taxRate);
      map.put("accountType", accountType);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("bizOrderNo", bizOrderNo);
      map.put("cipherTextQRCode", cipherTextQRCode);
      map.put("invoiceStyleType", invoiceStyleType);
      map.put("saleListFileFlag", saleListFileFlag);
      map.put("specialType", specialType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sellerTenantCode", sellerTenantCode);
      map.put("buyerTenantCode", buyerTenantCode);
      map.put("dataSource", dataSource);
      map.put("filterFlag", filterFlag);
      map.put("specialInvoiceFlag", specialInvoiceFlag);
      map.put("dateIssuedYear", dateIssuedYear);
      map.put("dateIssuedMonth", dateIssuedMonth);
      map.put("vatUsageLabel", vatUsageLabel);
      map.put("riskStatus", riskStatus);
      map.put("entryTime", entryTime);
      map.put("entryStatus", entryStatus);
      map.put("consumptionTaxCheckPeriod", consumptionTaxCheckPeriod);
      map.put("lastUpdateTime", BocpGenUtils.toTimestamp(lastUpdateTime));
      map.put("ack", ack);
      map.put("ackTime", BocpGenUtils.toTimestamp(ackTime));
      map.put("dateIssuedTime", BocpGenUtils.toTimestamp(dateIssuedTime));
      map.put("vatCheckPeriod", vatCheckPeriod);
      map.put("consumptionTaxCheckLabel", consumptionTaxCheckLabel);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("synTime", BocpGenUtils.toTimestamp(synTime));
      map.put("reverseList", reverseList);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("invoiceDetailSize", invoiceDetailSize);
      map.put("amountWithTaxConsistencyFlag", amountWithTaxConsistencyFlag);
      map.put("lastInvoiceType", lastInvoiceType);
      map.put("changeTaxNo", changeTaxNo);
      map.put("digestCode", digestCode);
      map.put("checkKey", checkKey);
      map.put("firstInvoiceType", firstInvoiceType);
      map.put("hasChangeInvoiceType", hasChangeInvoiceType);
      map.put("deleteStatus", deleteStatus);

      map.put("vehicleInfo.id", vehicleInfoId);
      return map;
  }

  public static BaseStandardInvoiceMain fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    BaseStandardInvoiceMain entity = new BaseStandardInvoiceMain();

    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssued")) {
      Object obj = map.get("dateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerNo")) {
      Object obj = map.get("buyerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReverseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReverseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReverseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReverseTime(null);
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddressTel")) {
      Object obj = map.get("buyerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankInfo")) {
      Object obj = map.get("buyerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddressTel")) {
      Object obj = map.get("sellerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSource")) {
      Object obj = map.get("invoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseFlag")) {
      Object obj = map.get("reverseFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewUrl")) {
      Object obj = map.get("viewUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setViewUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextQRCode")) {
      Object obj = map.get("cipherTextQRCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherTextQRCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStyleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSaleListFileFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleListFileFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialType")) {
      Object obj = map.get("specialType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTenantCode")) {
      Object obj = map.get("buyerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filterFlag")) {
      Object obj = map.get("filterFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFilterFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFilterFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssuedYear")) {
      Object obj = map.get("dateIssuedYear");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDateIssuedYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssuedMonth")) {
      Object obj = map.get("dateIssuedMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDateIssuedMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatUsageLabel")) {
      Object obj = map.get("vatUsageLabel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatUsageLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("riskStatus")) {
      Object obj = map.get("riskStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryTime")) {
      Object obj = map.get("entryTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryStatus")) {
      Object obj = map.get("entryStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEntryStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consumptionTaxCheckPeriod")) {
      Object obj = map.get("consumptionTaxCheckPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsumptionTaxCheckPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastUpdateTime")) {
      Object obj = map.get("lastUpdateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLastUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastUpdateTime(null);
      }
    }
    if(map.containsKey("ack")) {
      Object obj = map.get("ack");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setAck((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAck(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ackTime")) {
      Object obj = map.get("ackTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAckTime(null);
      }
    }
    if(map.containsKey("dateIssuedTime")) {
      Object obj = map.get("dateIssuedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateIssuedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDateIssuedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDateIssuedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDateIssuedTime(null);
      }
    }
    if(map.containsKey("vatCheckPeriod")) {
      Object obj = map.get("vatCheckPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatCheckPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consumptionTaxCheckLabel")) {
      Object obj = map.get("consumptionTaxCheckLabel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsumptionTaxCheckLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("synTime")) {
      Object obj = map.get("synTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSynTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSynTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSynTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSynTime(null);
      }
    }
    if(map.containsKey("reverseList")) {
      Object obj = map.get("reverseList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDetailSize")) {
      Object obj = map.get("invoiceDetailSize");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDetailSize((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceDetailSize(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceDetailSize(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxConsistencyFlag")) {
      Object obj = map.get("amountWithTaxConsistencyFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setAmountWithTaxConsistencyFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTaxConsistencyFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("lastInvoiceType")) {
      Object obj = map.get("lastInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeTaxNo")) {
      Object obj = map.get("changeTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChangeTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("digestCode")) {
      Object obj = map.get("digestCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDigestCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkKey")) {
      Object obj = map.get("checkKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstInvoiceType")) {
      Object obj = map.get("firstInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hasChangeInvoiceType")) {
      Object obj = map.get("hasChangeInvoiceType");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setHasChangeInvoiceType((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHasChangeInvoiceType(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("deleteStatus")) {
      Object obj = map.get("deleteStatus");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDeleteStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeleteStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }

    if(map.containsKey("vehicleInfo.id")) {
       Object obj = map.get("vehicleInfo.id");
       if(obj instanceof Long) {
         entity.setVehicleInfoId((Long)obj);
       } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
         entity.setVehicleInfoId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssued")) {
      Object obj = map.get("dateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machineCode")) {
      Object obj = map.get("machineCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payee")) {
      Object obj = map.get("payee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPayee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuer")) {
      Object obj = map.get("issuer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIssuer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerNo")) {
      Object obj = map.get("buyerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseTime")) {
      Object obj = map.get("reverseTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setReverseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setReverseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setReverseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setReverseTime(null);
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddressTel")) {
      Object obj = map.get("buyerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankInfo")) {
      Object obj = map.get("buyerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddressTel")) {
      Object obj = map.get("sellerAddressTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddressTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceKind")) {
      Object obj = map.get("invoiceKind");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceSource")) {
      Object obj = map.get("invoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseFlag")) {
      Object obj = map.get("reverseFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReverseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("viewUrl")) {
      Object obj = map.get("viewUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setViewUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextQRCode")) {
      Object obj = map.get("cipherTextQRCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherTextQRCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStyleType")) {
      Object obj = map.get("invoiceStyleType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceStyleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("saleListFileFlag")) {
      Object obj = map.get("saleListFileFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setSaleListFileFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSaleListFileFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialType")) {
      Object obj = map.get("specialType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTenantCode")) {
      Object obj = map.get("buyerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBuyerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("filterFlag")) {
      Object obj = map.get("filterFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setFilterFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setFilterFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("specialInvoiceFlag")) {
      Object obj = map.get("specialInvoiceFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssuedYear")) {
      Object obj = map.get("dateIssuedYear");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDateIssuedYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dateIssuedMonth")) {
      Object obj = map.get("dateIssuedMonth");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDateIssuedMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatUsageLabel")) {
      Object obj = map.get("vatUsageLabel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVatUsageLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("riskStatus")) {
      Object obj = map.get("riskStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRiskStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryTime")) {
      Object obj = map.get("entryTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEntryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entryStatus")) {
      Object obj = map.get("entryStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setEntryStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consumptionTaxCheckPeriod")) {
      Object obj = map.get("consumptionTaxCheckPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setConsumptionTaxCheckPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastUpdateTime")) {
      Object obj = map.get("lastUpdateTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setLastUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setLastUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setLastUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setLastUpdateTime(null);
      }
    }
    if(map.containsKey("ack")) {
      Object obj = map.get("ack");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setAck((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAck(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ackTime")) {
      Object obj = map.get("ackTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAckTime(null);
      }
    }
    if(map.containsKey("dateIssuedTime")) {
      Object obj = map.get("dateIssuedTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDateIssuedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDateIssuedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDateIssuedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDateIssuedTime(null);
      }
    }
    if(map.containsKey("vatCheckPeriod")) {
      Object obj = map.get("vatCheckPeriod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVatCheckPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consumptionTaxCheckLabel")) {
      Object obj = map.get("consumptionTaxCheckLabel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setConsumptionTaxCheckLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("synTime")) {
      Object obj = map.get("synTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSynTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSynTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSynTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSynTime(null);
      }
    }
    if(map.containsKey("reverseList")) {
      Object obj = map.get("reverseList");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReverseList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDetailSize")) {
      Object obj = map.get("invoiceDetailSize");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceDetailSize((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceDetailSize(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceDetailSize(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxConsistencyFlag")) {
      Object obj = map.get("amountWithTaxConsistencyFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setAmountWithTaxConsistencyFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTaxConsistencyFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("lastInvoiceType")) {
      Object obj = map.get("lastInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLastInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeTaxNo")) {
      Object obj = map.get("changeTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setChangeTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("digestCode")) {
      Object obj = map.get("digestCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDigestCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkKey")) {
      Object obj = map.get("checkKey");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstInvoiceType")) {
      Object obj = map.get("firstInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFirstInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hasChangeInvoiceType")) {
      Object obj = map.get("hasChangeInvoiceType");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setHasChangeInvoiceType((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setHasChangeInvoiceType(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("deleteStatus")) {
      Object obj = map.get("deleteStatus");
      if(obj != null) {
        if(obj instanceof Boolean) {
            this.setDeleteStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setDeleteStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
  if(map.containsKey("vehicleInfo.id")) {
    Object obj = map.get("vehicleInfo.id");
    if(obj instanceof Long) {
        this.setVehicleInfoId((Long)obj);
    } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        this.setVehicleInfoId(Long.parseLong((String)obj));
    }
  }
  }
}
