package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.AggregatedPurchaseInvoiceItem;
import com.xforceplus.ultraman.app.openapirapi.service.IAggregatedPurchaseInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class AggregatedPurchaseInvoiceItemController {

  @Autowired
  private IAggregatedPurchaseInvoiceItemService aggregatedPurchaseInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aggregatedPurchaseInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/aggregatedpurchaseinvoiceitems" )
  public XfR getAggregatedPurchaseInvoiceItems(XfPage page, AggregatedPurchaseInvoiceItem aggregatedPurchaseInvoiceItem) {
    return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.page(page, Wrappers.query(aggregatedPurchaseInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/aggregatedpurchaseinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aggregatedPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/aggregatedpurchaseinvoiceitems")
  public XfR save(@RequestBody AggregatedPurchaseInvoiceItem aggregatedPurchaseInvoiceItem) {
     return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.save(aggregatedPurchaseInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aggregatedPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/aggregatedpurchaseinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody AggregatedPurchaseInvoiceItem aggregatedPurchaseInvoiceItem,@PathVariable Long id) {
      aggregatedPurchaseInvoiceItem.setId(id);
      return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.updateById(aggregatedPurchaseInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aggregatedPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/aggregatedpurchaseinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody AggregatedPurchaseInvoiceItem aggregatedPurchaseInvoiceItem,@PathVariable Long id) {
      AggregatedPurchaseInvoiceItem upaggregatedPurchaseInvoiceItem = aggregatedPurchaseInvoiceItemServiceImpl.getById(id);
      if(upaggregatedPurchaseInvoiceItem != null){
        upaggregatedPurchaseInvoiceItem = ObjectCopyUtils.copyProperties(aggregatedPurchaseInvoiceItem,upaggregatedPurchaseInvoiceItem,true);
      }
      return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.updateById(upaggregatedPurchaseInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aggregatedpurchaseinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/aggregatedpurchaseinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "aggregated_purchase_invoice_item");
     params.put("request", condition);

     return XfR.ok(aggregatedPurchaseInvoiceItemServiceImpl.querys(params));
  }

}
