package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.AsyncTask;
import com.xforceplus.ultraman.app.openapirapi.service.IAsyncTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class AsyncTaskController {

  @Autowired
  private IAsyncTaskService asyncTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param asyncTask ${table.comment}
   * @return
   */
  @GetMapping("/asynctasks" )
  public XfR getAsyncTasks(XfPage page, AsyncTask asyncTask) {
    return XfR.ok(asyncTaskServiceImpl.page(page, Wrappers.query(asyncTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/asynctasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(asyncTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param asyncTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/asynctasks")
  public XfR save(@RequestBody AsyncTask asyncTask) {
     return XfR.ok(asyncTaskServiceImpl.save(asyncTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param asyncTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/asynctasks/{id}")
  public XfR putUpdate(@RequestBody AsyncTask asyncTask,@PathVariable Long id) {
      asyncTask.setId(id);
      return XfR.ok(asyncTaskServiceImpl.updateById(asyncTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param asyncTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/asynctasks/{id}")
  public XfR patchUpdate(@RequestBody AsyncTask asyncTask,@PathVariable Long id) {
      AsyncTask upasyncTask = asyncTaskServiceImpl.getById(id);
      if(upasyncTask != null){
        upasyncTask = ObjectCopyUtils.copyProperties(asyncTask,upasyncTask,true);
      }
      return XfR.ok(asyncTaskServiceImpl.updateById(upasyncTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/asynctasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(asyncTaskServiceImpl.removeById(id));
  }

  @PostMapping("/asynctasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "async_task");
     params.put("request", condition);

     return XfR.ok(asyncTaskServiceImpl.querys(params));
  }

}
