package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.BaseStandardInvoiceMain;
import com.xforceplus.ultraman.app.openapirapi.service.IBaseStandardInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class BaseStandardInvoiceMainController {

  @Autowired
  private IBaseStandardInvoiceMainService baseStandardInvoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baseStandardInvoiceMain ${table.comment}
   * @return
   */
  @GetMapping("/basestandardinvoicemains" )
  public XfR getBaseStandardInvoiceMains(XfPage page, BaseStandardInvoiceMain baseStandardInvoiceMain) {
    return XfR.ok(baseStandardInvoiceMainServiceImpl.page(page, Wrappers.query(baseStandardInvoiceMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basestandardinvoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baseStandardInvoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baseStandardInvoiceMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/basestandardinvoicemains")
  public XfR save(@RequestBody BaseStandardInvoiceMain baseStandardInvoiceMain) {
     return XfR.ok(baseStandardInvoiceMainServiceImpl.save(baseStandardInvoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baseStandardInvoiceMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/basestandardinvoicemains/{id}")
  public XfR putUpdate(@RequestBody BaseStandardInvoiceMain baseStandardInvoiceMain,@PathVariable Long id) {
      baseStandardInvoiceMain.setId(id);
      return XfR.ok(baseStandardInvoiceMainServiceImpl.updateById(baseStandardInvoiceMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baseStandardInvoiceMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basestandardinvoicemains/{id}")
  public XfR patchUpdate(@RequestBody BaseStandardInvoiceMain baseStandardInvoiceMain,@PathVariable Long id) {
      BaseStandardInvoiceMain upbaseStandardInvoiceMain = baseStandardInvoiceMainServiceImpl.getById(id);
      if(upbaseStandardInvoiceMain != null){
        upbaseStandardInvoiceMain = ObjectCopyUtils.copyProperties(baseStandardInvoiceMain,upbaseStandardInvoiceMain,true);
      }
      return XfR.ok(baseStandardInvoiceMainServiceImpl.updateById(upbaseStandardInvoiceMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basestandardinvoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baseStandardInvoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/basestandardinvoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "base_standard_invoice_main");
     params.put("request", condition);

     return XfR.ok(baseStandardInvoiceMainServiceImpl.querys(params));
  }

}
