package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterBaseNonVat;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterBaseNonVatService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class FilterBaseNonVatController {

  @Autowired
  private IFilterBaseNonVatService filterBaseNonVatServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterBaseNonVat ${table.comment}
   * @return
   */
  @GetMapping("/filterbasenonvats" )
  public XfR getFilterBaseNonVats(XfPage page, FilterBaseNonVat filterBaseNonVat) {
    return XfR.ok(filterBaseNonVatServiceImpl.page(page, Wrappers.query(filterBaseNonVat)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterbasenonvats/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterBaseNonVatServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterBaseNonVat ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterbasenonvats")
  public XfR save(@RequestBody FilterBaseNonVat filterBaseNonVat) {
     return XfR.ok(filterBaseNonVatServiceImpl.save(filterBaseNonVat));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterBaseNonVat ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterbasenonvats/{id}")
  public XfR putUpdate(@RequestBody FilterBaseNonVat filterBaseNonVat,@PathVariable Long id) {
      filterBaseNonVat.setId(id);
      return XfR.ok(filterBaseNonVatServiceImpl.updateById(filterBaseNonVat));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterBaseNonVat ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterbasenonvats/{id}")
  public XfR patchUpdate(@RequestBody FilterBaseNonVat filterBaseNonVat,@PathVariable Long id) {
      FilterBaseNonVat upfilterBaseNonVat = filterBaseNonVatServiceImpl.getById(id);
      if(upfilterBaseNonVat != null){
        upfilterBaseNonVat = ObjectCopyUtils.copyProperties(filterBaseNonVat,upfilterBaseNonVat,true);
      }
      return XfR.ok(filterBaseNonVatServiceImpl.updateById(upfilterBaseNonVat));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterbasenonvats/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterBaseNonVatServiceImpl.removeById(id));
  }

  @PostMapping("/filterbasenonvats/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_base_non_vat");
     params.put("request", condition);

     return XfR.ok(filterBaseNonVatServiceImpl.querys(params));
  }

}
