package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterPurchaseInvoiceItem;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterPurchaseInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class FilterPurchaseInvoiceItemController {

  @Autowired
  private IFilterPurchaseInvoiceItemService filterPurchaseInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterPurchaseInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/filterpurchaseinvoiceitems" )
  public XfR getFilterPurchaseInvoiceItems(XfPage page, FilterPurchaseInvoiceItem filterPurchaseInvoiceItem) {
    return XfR.ok(filterPurchaseInvoiceItemServiceImpl.page(page, Wrappers.query(filterPurchaseInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterpurchaseinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterPurchaseInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterpurchaseinvoiceitems")
  public XfR save(@RequestBody FilterPurchaseInvoiceItem filterPurchaseInvoiceItem) {
     return XfR.ok(filterPurchaseInvoiceItemServiceImpl.save(filterPurchaseInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterpurchaseinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody FilterPurchaseInvoiceItem filterPurchaseInvoiceItem,@PathVariable Long id) {
      filterPurchaseInvoiceItem.setId(id);
      return XfR.ok(filterPurchaseInvoiceItemServiceImpl.updateById(filterPurchaseInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterPurchaseInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterpurchaseinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody FilterPurchaseInvoiceItem filterPurchaseInvoiceItem,@PathVariable Long id) {
      FilterPurchaseInvoiceItem upfilterPurchaseInvoiceItem = filterPurchaseInvoiceItemServiceImpl.getById(id);
      if(upfilterPurchaseInvoiceItem != null){
        upfilterPurchaseInvoiceItem = ObjectCopyUtils.copyProperties(filterPurchaseInvoiceItem,upfilterPurchaseInvoiceItem,true);
      }
      return XfR.ok(filterPurchaseInvoiceItemServiceImpl.updateById(upfilterPurchaseInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterpurchaseinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterPurchaseInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/filterpurchaseinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_purchase_invoice_item");
     params.put("request", condition);

     return XfR.ok(filterPurchaseInvoiceItemServiceImpl.querys(params));
  }

}
