package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterTicketPlane;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterTicketPlaneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class FilterTicketPlaneController {

  @Autowired
  private IFilterTicketPlaneService filterTicketPlaneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterTicketPlane ${table.comment}
   * @return
   */
  @GetMapping("/filterticketplanes" )
  public XfR getFilterTicketPlanes(XfPage page, FilterTicketPlane filterTicketPlane) {
    return XfR.ok(filterTicketPlaneServiceImpl.page(page, Wrappers.query(filterTicketPlane)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterticketplanes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterTicketPlaneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterTicketPlane ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterticketplanes")
  public XfR save(@RequestBody FilterTicketPlane filterTicketPlane) {
     return XfR.ok(filterTicketPlaneServiceImpl.save(filterTicketPlane));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterTicketPlane ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterticketplanes/{id}")
  public XfR putUpdate(@RequestBody FilterTicketPlane filterTicketPlane,@PathVariable Long id) {
      filterTicketPlane.setId(id);
      return XfR.ok(filterTicketPlaneServiceImpl.updateById(filterTicketPlane));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterTicketPlane ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterticketplanes/{id}")
  public XfR patchUpdate(@RequestBody FilterTicketPlane filterTicketPlane,@PathVariable Long id) {
      FilterTicketPlane upfilterTicketPlane = filterTicketPlaneServiceImpl.getById(id);
      if(upfilterTicketPlane != null){
        upfilterTicketPlane = ObjectCopyUtils.copyProperties(filterTicketPlane,upfilterTicketPlane,true);
      }
      return XfR.ok(filterTicketPlaneServiceImpl.updateById(upfilterTicketPlane));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterticketplanes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterTicketPlaneServiceImpl.removeById(id));
  }

  @PostMapping("/filterticketplanes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_ticket_plane");
     params.put("request", condition);

     return XfR.ok(filterTicketPlaneServiceImpl.querys(params));
  }

}
