package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.SubAsyncTask;
import com.xforceplus.ultraman.app.openapirapi.service.ISubAsyncTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-10
 */
@RestController
public class SubAsyncTaskController {

  @Autowired
  private ISubAsyncTaskService subAsyncTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param subAsyncTask ${table.comment}
   * @return
   */
  @GetMapping("/subasynctasks" )
  public XfR getSubAsyncTasks(XfPage page, SubAsyncTask subAsyncTask) {
    return XfR.ok(subAsyncTaskServiceImpl.page(page, Wrappers.query(subAsyncTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/subasynctasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(subAsyncTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param subAsyncTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/subasynctasks")
  public XfR save(@RequestBody SubAsyncTask subAsyncTask) {
     return XfR.ok(subAsyncTaskServiceImpl.save(subAsyncTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param subAsyncTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/subasynctasks/{id}")
  public XfR putUpdate(@RequestBody SubAsyncTask subAsyncTask,@PathVariable Long id) {
      subAsyncTask.setId(id);
      return XfR.ok(subAsyncTaskServiceImpl.updateById(subAsyncTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param subAsyncTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/subasynctasks/{id}")
  public XfR patchUpdate(@RequestBody SubAsyncTask subAsyncTask,@PathVariable Long id) {
      SubAsyncTask upsubAsyncTask = subAsyncTaskServiceImpl.getById(id);
      if(upsubAsyncTask != null){
        upsubAsyncTask = ObjectCopyUtils.copyProperties(subAsyncTask,upsubAsyncTask,true);
      }
      return XfR.ok(subAsyncTaskServiceImpl.updateById(upsubAsyncTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/subasynctasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(subAsyncTaskServiceImpl.removeById(id));
  }

  @PostMapping("/subasynctasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sub_async_task");
     params.put("request", condition);

     return XfR.ok(subAsyncTaskServiceImpl.querys(params));
  }

}
