package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.AggregatedSalesInvoice;
import com.xforceplus.ultraman.app.openapirapi.service.IAggregatedSalesInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-20
 */
@RestController
public class AggregatedSalesInvoiceController {

  @Autowired
  private IAggregatedSalesInvoiceService aggregatedSalesInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aggregatedSalesInvoice ${table.comment}
   * @return
   */
  @GetMapping("/aggregatedsalesinvoices" )
  public XfR getAggregatedSalesInvoices(XfPage page, AggregatedSalesInvoice aggregatedSalesInvoice) {
    return XfR.ok(aggregatedSalesInvoiceServiceImpl.page(page, Wrappers.query(aggregatedSalesInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/aggregatedsalesinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(aggregatedSalesInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aggregatedSalesInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/aggregatedsalesinvoices")
  public XfR save(@RequestBody AggregatedSalesInvoice aggregatedSalesInvoice) {
     return XfR.ok(aggregatedSalesInvoiceServiceImpl.save(aggregatedSalesInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aggregatedSalesInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/aggregatedsalesinvoices/{id}")
  public XfR putUpdate(@RequestBody AggregatedSalesInvoice aggregatedSalesInvoice,@PathVariable Long id) {
      aggregatedSalesInvoice.setId(id);
      return XfR.ok(aggregatedSalesInvoiceServiceImpl.updateById(aggregatedSalesInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aggregatedSalesInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/aggregatedsalesinvoices/{id}")
  public XfR patchUpdate(@RequestBody AggregatedSalesInvoice aggregatedSalesInvoice,@PathVariable Long id) {
      AggregatedSalesInvoice upaggregatedSalesInvoice = aggregatedSalesInvoiceServiceImpl.getById(id);
      if(upaggregatedSalesInvoice != null){
        upaggregatedSalesInvoice = ObjectCopyUtils.copyProperties(aggregatedSalesInvoice,upaggregatedSalesInvoice,true);
      }
      return XfR.ok(aggregatedSalesInvoiceServiceImpl.updateById(upaggregatedSalesInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aggregatedsalesinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(aggregatedSalesInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/aggregatedsalesinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "aggregated_sales_invoice");
     params.put("request", condition);

     return XfR.ok(aggregatedSalesInvoiceServiceImpl.querys(params));
  }

}
