package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.InvoiceSendStatistic;
import com.xforceplus.ultraman.app.openapirapi.service.IInvoiceSendStatisticService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-20
 */
@RestController
public class InvoiceSendStatisticController {

  @Autowired
  private IInvoiceSendStatisticService invoiceSendStatisticServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSendStatistic ${table.comment}
   * @return
   */
  @GetMapping("/invoicesendstatistics" )
  public XfR getInvoiceSendStatistics(XfPage page, InvoiceSendStatistic invoiceSendStatistic) {
    return XfR.ok(invoiceSendStatisticServiceImpl.page(page, Wrappers.query(invoiceSendStatistic)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicesendstatistics/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSendStatisticServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceSendStatistic ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicesendstatistics")
  public XfR save(@RequestBody InvoiceSendStatistic invoiceSendStatistic) {
     return XfR.ok(invoiceSendStatisticServiceImpl.save(invoiceSendStatistic));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceSendStatistic ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicesendstatistics/{id}")
  public XfR putUpdate(@RequestBody InvoiceSendStatistic invoiceSendStatistic,@PathVariable Long id) {
      invoiceSendStatistic.setId(id);
      return XfR.ok(invoiceSendStatisticServiceImpl.updateById(invoiceSendStatistic));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceSendStatistic ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicesendstatistics/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSendStatistic invoiceSendStatistic,@PathVariable Long id) {
      InvoiceSendStatistic upinvoiceSendStatistic = invoiceSendStatisticServiceImpl.getById(id);
      if(upinvoiceSendStatistic != null){
        upinvoiceSendStatistic = ObjectCopyUtils.copyProperties(invoiceSendStatistic,upinvoiceSendStatistic,true);
      }
      return XfR.ok(invoiceSendStatisticServiceImpl.updateById(upinvoiceSendStatistic));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicesendstatistics/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSendStatisticServiceImpl.removeById(id));
  }

  @PostMapping("/invoicesendstatistics/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_send_statistic");
     params.put("request", condition);

     return XfR.ok(invoiceSendStatisticServiceImpl.querys(params));
  }

}
