package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.Messagehistory;
import com.xforceplus.ultraman.app.openapirapi.service.IMessagehistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-25
 */
@RestController
public class MessagehistoryController {

  @Autowired
  private IMessagehistoryService messagehistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param messagehistory ${table.comment}
   * @return
   */
  @GetMapping("/messagehistorys" )
  public XfR getMessagehistorys(XfPage page, Messagehistory messagehistory) {
    return XfR.ok(messagehistoryServiceImpl.page(page, Wrappers.query(messagehistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/messagehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(messagehistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param messagehistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/messagehistorys")
  public XfR save(@RequestBody Messagehistory messagehistory) {
     return XfR.ok(messagehistoryServiceImpl.save(messagehistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param messagehistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/messagehistorys/{id}")
  public XfR putUpdate(@RequestBody Messagehistory messagehistory,@PathVariable Long id) {
      messagehistory.setId(id);
      return XfR.ok(messagehistoryServiceImpl.updateById(messagehistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param messagehistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/messagehistorys/{id}")
  public XfR patchUpdate(@RequestBody Messagehistory messagehistory,@PathVariable Long id) {
      Messagehistory upmessagehistory = messagehistoryServiceImpl.getById(id);
      if(upmessagehistory != null){
        upmessagehistory = ObjectCopyUtils.copyProperties(messagehistory,upmessagehistory,true);
      }
      return XfR.ok(messagehistoryServiceImpl.updateById(upmessagehistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/messagehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(messagehistoryServiceImpl.removeById(id));
  }

  @PostMapping("/messagehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "messagehistory");
     params.put("request", condition);

     return XfR.ok(messagehistoryServiceImpl.querys(params));
  }

}
