package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.AggregatedSalesInvoiceItem;
import com.xforceplus.ultraman.app.openapirapi.service.IAggregatedSalesInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-19
 */
@RestController
public class AggregatedSalesInvoiceItemController {

  @Autowired
  private IAggregatedSalesInvoiceItemService aggregatedSalesInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aggregatedSalesInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/aggregatedsalesinvoiceitems" )
  public XfR getAggregatedSalesInvoiceItems(XfPage page, AggregatedSalesInvoiceItem aggregatedSalesInvoiceItem) {
    return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.page(page, Wrappers.query(aggregatedSalesInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/aggregatedsalesinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aggregatedSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/aggregatedsalesinvoiceitems")
  public XfR save(@RequestBody AggregatedSalesInvoiceItem aggregatedSalesInvoiceItem) {
     return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.save(aggregatedSalesInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aggregatedSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/aggregatedsalesinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody AggregatedSalesInvoiceItem aggregatedSalesInvoiceItem,@PathVariable Long id) {
      aggregatedSalesInvoiceItem.setId(id);
      return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.updateById(aggregatedSalesInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aggregatedSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/aggregatedsalesinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody AggregatedSalesInvoiceItem aggregatedSalesInvoiceItem,@PathVariable Long id) {
      AggregatedSalesInvoiceItem upaggregatedSalesInvoiceItem = aggregatedSalesInvoiceItemServiceImpl.getById(id);
      if(upaggregatedSalesInvoiceItem != null){
        upaggregatedSalesInvoiceItem = ObjectCopyUtils.copyProperties(aggregatedSalesInvoiceItem,upaggregatedSalesInvoiceItem,true);
      }
      return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.updateById(upaggregatedSalesInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aggregatedsalesinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/aggregatedsalesinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "aggregated_sales_invoice_item");
     params.put("request", condition);

     return XfR.ok(aggregatedSalesInvoiceItemServiceImpl.querys(params));
  }

}
