package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterInvoiceConditionConfig;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterInvoiceConditionConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-19
 */
@RestController
public class FilterInvoiceConditionConfigController {

  @Autowired
  private IFilterInvoiceConditionConfigService filterInvoiceConditionConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterInvoiceConditionConfig ${table.comment}
   * @return
   */
  @GetMapping("/filterinvoiceconditionconfigs" )
  public XfR getFilterInvoiceConditionConfigs(XfPage page, FilterInvoiceConditionConfig filterInvoiceConditionConfig) {
    return XfR.ok(filterInvoiceConditionConfigServiceImpl.page(page, Wrappers.query(filterInvoiceConditionConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterinvoiceconditionconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterInvoiceConditionConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterInvoiceConditionConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterinvoiceconditionconfigs")
  public XfR save(@RequestBody FilterInvoiceConditionConfig filterInvoiceConditionConfig) {
     return XfR.ok(filterInvoiceConditionConfigServiceImpl.save(filterInvoiceConditionConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterInvoiceConditionConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterinvoiceconditionconfigs/{id}")
  public XfR putUpdate(@RequestBody FilterInvoiceConditionConfig filterInvoiceConditionConfig,@PathVariable Long id) {
      filterInvoiceConditionConfig.setId(id);
      return XfR.ok(filterInvoiceConditionConfigServiceImpl.updateById(filterInvoiceConditionConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterInvoiceConditionConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterinvoiceconditionconfigs/{id}")
  public XfR patchUpdate(@RequestBody FilterInvoiceConditionConfig filterInvoiceConditionConfig,@PathVariable Long id) {
      FilterInvoiceConditionConfig upfilterInvoiceConditionConfig = filterInvoiceConditionConfigServiceImpl.getById(id);
      if(upfilterInvoiceConditionConfig != null){
        upfilterInvoiceConditionConfig = ObjectCopyUtils.copyProperties(filterInvoiceConditionConfig,upfilterInvoiceConditionConfig,true);
      }
      return XfR.ok(filterInvoiceConditionConfigServiceImpl.updateById(upfilterInvoiceConditionConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterinvoiceconditionconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterInvoiceConditionConfigServiceImpl.removeById(id));
  }

  @PostMapping("/filterinvoiceconditionconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_invoice_condition_config");
     params.put("request", condition);

     return XfR.ok(filterInvoiceConditionConfigServiceImpl.querys(params));
  }

}
