package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterPurchaseInvoice;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterPurchaseInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-19
 */
@RestController
public class FilterPurchaseInvoiceController {

  @Autowired
  private IFilterPurchaseInvoiceService filterPurchaseInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterPurchaseInvoice ${table.comment}
   * @return
   */
  @GetMapping("/filterpurchaseinvoices" )
  public XfR getFilterPurchaseInvoices(XfPage page, FilterPurchaseInvoice filterPurchaseInvoice) {
    return XfR.ok(filterPurchaseInvoiceServiceImpl.page(page, Wrappers.query(filterPurchaseInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterpurchaseinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterPurchaseInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterpurchaseinvoices")
  public XfR save(@RequestBody FilterPurchaseInvoice filterPurchaseInvoice) {
     return XfR.ok(filterPurchaseInvoiceServiceImpl.save(filterPurchaseInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterpurchaseinvoices/{id}")
  public XfR putUpdate(@RequestBody FilterPurchaseInvoice filterPurchaseInvoice,@PathVariable Long id) {
      filterPurchaseInvoice.setId(id);
      return XfR.ok(filterPurchaseInvoiceServiceImpl.updateById(filterPurchaseInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterpurchaseinvoices/{id}")
  public XfR patchUpdate(@RequestBody FilterPurchaseInvoice filterPurchaseInvoice,@PathVariable Long id) {
      FilterPurchaseInvoice upfilterPurchaseInvoice = filterPurchaseInvoiceServiceImpl.getById(id);
      if(upfilterPurchaseInvoice != null){
        upfilterPurchaseInvoice = ObjectCopyUtils.copyProperties(filterPurchaseInvoice,upfilterPurchaseInvoice,true);
      }
      return XfR.ok(filterPurchaseInvoiceServiceImpl.updateById(upfilterPurchaseInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterpurchaseinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterPurchaseInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/filterpurchaseinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_purchase_invoice");
     params.put("request", condition);

     return XfR.ok(filterPurchaseInvoiceServiceImpl.querys(params));
  }

}
