package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterTicketPlaneDetail;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterTicketPlaneDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-19
 */
@RestController
public class FilterTicketPlaneDetailController {

  @Autowired
  private IFilterTicketPlaneDetailService filterTicketPlaneDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterTicketPlaneDetail ${table.comment}
   * @return
   */
  @GetMapping("/filterticketplanedetails" )
  public XfR getFilterTicketPlaneDetails(XfPage page, FilterTicketPlaneDetail filterTicketPlaneDetail) {
    return XfR.ok(filterTicketPlaneDetailServiceImpl.page(page, Wrappers.query(filterTicketPlaneDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filterticketplanedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterTicketPlaneDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterTicketPlaneDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/filterticketplanedetails")
  public XfR save(@RequestBody FilterTicketPlaneDetail filterTicketPlaneDetail) {
     return XfR.ok(filterTicketPlaneDetailServiceImpl.save(filterTicketPlaneDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterTicketPlaneDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/filterticketplanedetails/{id}")
  public XfR putUpdate(@RequestBody FilterTicketPlaneDetail filterTicketPlaneDetail,@PathVariable Long id) {
      filterTicketPlaneDetail.setId(id);
      return XfR.ok(filterTicketPlaneDetailServiceImpl.updateById(filterTicketPlaneDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterTicketPlaneDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filterticketplanedetails/{id}")
  public XfR patchUpdate(@RequestBody FilterTicketPlaneDetail filterTicketPlaneDetail,@PathVariable Long id) {
      FilterTicketPlaneDetail upfilterTicketPlaneDetail = filterTicketPlaneDetailServiceImpl.getById(id);
      if(upfilterTicketPlaneDetail != null){
        upfilterTicketPlaneDetail = ObjectCopyUtils.copyProperties(filterTicketPlaneDetail,upfilterTicketPlaneDetail,true);
      }
      return XfR.ok(filterTicketPlaneDetailServiceImpl.updateById(upfilterTicketPlaneDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filterticketplanedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterTicketPlaneDetailServiceImpl.removeById(id));
  }

  @PostMapping("/filterticketplanedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_ticket_plane_detail");
     params.put("request", condition);

     return XfR.ok(filterTicketPlaneDetailServiceImpl.querys(params));
  }

}
