package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.FilterTicketTrain;
import com.xforceplus.ultraman.app.openapirapi.service.IFilterTicketTrainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-19
 */
@RestController
public class FilterTicketTrainController {

  @Autowired
  private IFilterTicketTrainService filterTicketTrainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterTicketTrain ${table.comment}
   * @return
   */
  @GetMapping("/filtertickettrains" )
  public XfR getFilterTicketTrains(XfPage page, FilterTicketTrain filterTicketTrain) {
    return XfR.ok(filterTicketTrainServiceImpl.page(page, Wrappers.query(filterTicketTrain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filtertickettrains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterTicketTrainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterTicketTrain ${table.comment}
   * @return XfR
   */
  @PostMapping("/filtertickettrains")
  public XfR save(@RequestBody FilterTicketTrain filterTicketTrain) {
     return XfR.ok(filterTicketTrainServiceImpl.save(filterTicketTrain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterTicketTrain ${table.comment}
   * @return XfR
   */
  @PutMapping("/filtertickettrains/{id}")
  public XfR putUpdate(@RequestBody FilterTicketTrain filterTicketTrain,@PathVariable Long id) {
      filterTicketTrain.setId(id);
      return XfR.ok(filterTicketTrainServiceImpl.updateById(filterTicketTrain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterTicketTrain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filtertickettrains/{id}")
  public XfR patchUpdate(@RequestBody FilterTicketTrain filterTicketTrain,@PathVariable Long id) {
      FilterTicketTrain upfilterTicketTrain = filterTicketTrainServiceImpl.getById(id);
      if(upfilterTicketTrain != null){
        upfilterTicketTrain = ObjectCopyUtils.copyProperties(filterTicketTrain,upfilterTicketTrain,true);
      }
      return XfR.ok(filterTicketTrainServiceImpl.updateById(upfilterTicketTrain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filtertickettrains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterTicketTrainServiceImpl.removeById(id));
  }

  @PostMapping("/filtertickettrains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_ticket_train");
     params.put("request", condition);

     return XfR.ok(filterTicketTrainServiceImpl.querys(params));
  }

}
