package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.TaxMessageStatistics;
import com.xforceplus.ultraman.app.openapirapi.service.ITaxMessageStatisticsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-19
 */
@RestController
public class TaxMessageStatisticsController {

  @Autowired
  private ITaxMessageStatisticsService taxMessageStatisticsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxMessageStatistics ${table.comment}
   * @return
   */
  @GetMapping("/taxmessagestatisticss" )
  public XfR getTaxMessageStatisticss(XfPage page, TaxMessageStatistics taxMessageStatistics) {
    return XfR.ok(taxMessageStatisticsServiceImpl.page(page, Wrappers.query(taxMessageStatistics)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxmessagestatisticss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxMessageStatisticsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxMessageStatistics ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxmessagestatisticss")
  public XfR save(@RequestBody TaxMessageStatistics taxMessageStatistics) {
     return XfR.ok(taxMessageStatisticsServiceImpl.save(taxMessageStatistics));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxMessageStatistics ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxmessagestatisticss/{id}")
  public XfR putUpdate(@RequestBody TaxMessageStatistics taxMessageStatistics,@PathVariable Long id) {
      taxMessageStatistics.setId(id);
      return XfR.ok(taxMessageStatisticsServiceImpl.updateById(taxMessageStatistics));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxMessageStatistics ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxmessagestatisticss/{id}")
  public XfR patchUpdate(@RequestBody TaxMessageStatistics taxMessageStatistics,@PathVariable Long id) {
      TaxMessageStatistics uptaxMessageStatistics = taxMessageStatisticsServiceImpl.getById(id);
      if(uptaxMessageStatistics != null){
        uptaxMessageStatistics = ObjectCopyUtils.copyProperties(taxMessageStatistics,uptaxMessageStatistics,true);
      }
      return XfR.ok(taxMessageStatisticsServiceImpl.updateById(uptaxMessageStatistics));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxmessagestatisticss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxMessageStatisticsServiceImpl.removeById(id));
  }

  @PostMapping("/taxmessagestatisticss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_message_statistics");
     params.put("request", condition);

     return XfR.ok(taxMessageStatisticsServiceImpl.querys(params));
  }

}
