package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.AggregatedPurchaseInvoice;
import com.xforceplus.ultraman.app.openapirapi.service.IAggregatedPurchaseInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-04
 */
@RestController
public class AggregatedPurchaseInvoiceController {

  @Autowired
  private IAggregatedPurchaseInvoiceService aggregatedPurchaseInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aggregatedPurchaseInvoice ${table.comment}
   * @return
   */
  @GetMapping("/aggregatedpurchaseinvoices" )
  public XfR getAggregatedPurchaseInvoices(XfPage page, AggregatedPurchaseInvoice aggregatedPurchaseInvoice) {
    return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.page(page, Wrappers.query(aggregatedPurchaseInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/aggregatedpurchaseinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aggregatedPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/aggregatedpurchaseinvoices")
  public XfR save(@RequestBody AggregatedPurchaseInvoice aggregatedPurchaseInvoice) {
     return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.save(aggregatedPurchaseInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aggregatedPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/aggregatedpurchaseinvoices/{id}")
  public XfR putUpdate(@RequestBody AggregatedPurchaseInvoice aggregatedPurchaseInvoice,@PathVariable Long id) {
      aggregatedPurchaseInvoice.setId(id);
      return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.updateById(aggregatedPurchaseInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aggregatedPurchaseInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/aggregatedpurchaseinvoices/{id}")
  public XfR patchUpdate(@RequestBody AggregatedPurchaseInvoice aggregatedPurchaseInvoice,@PathVariable Long id) {
      AggregatedPurchaseInvoice upaggregatedPurchaseInvoice = aggregatedPurchaseInvoiceServiceImpl.getById(id);
      if(upaggregatedPurchaseInvoice != null){
        upaggregatedPurchaseInvoice = ObjectCopyUtils.copyProperties(aggregatedPurchaseInvoice,upaggregatedPurchaseInvoice,true);
      }
      return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.updateById(upaggregatedPurchaseInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aggregatedpurchaseinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/aggregatedpurchaseinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "aggregated_purchase_invoice");
     params.put("request", condition);

     return XfR.ok(aggregatedPurchaseInvoiceServiceImpl.querys(params));
  }

}
