package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.InvoiceStatisticCompanyInfo;
import com.xforceplus.ultraman.app.openapirapi.service.IInvoiceStatisticCompanyInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-04
 */
@RestController
public class InvoiceStatisticCompanyInfoController {

  @Autowired
  private IInvoiceStatisticCompanyInfoService invoiceStatisticCompanyInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceStatisticCompanyInfo ${table.comment}
   * @return
   */
  @GetMapping("/invoicestatisticcompanyinfos" )
  public XfR getInvoiceStatisticCompanyInfos(XfPage page, InvoiceStatisticCompanyInfo invoiceStatisticCompanyInfo) {
    return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.page(page, Wrappers.query(invoiceStatisticCompanyInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicestatisticcompanyinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceStatisticCompanyInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicestatisticcompanyinfos")
  public XfR save(@RequestBody InvoiceStatisticCompanyInfo invoiceStatisticCompanyInfo) {
     return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.save(invoiceStatisticCompanyInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceStatisticCompanyInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicestatisticcompanyinfos/{id}")
  public XfR putUpdate(@RequestBody InvoiceStatisticCompanyInfo invoiceStatisticCompanyInfo,@PathVariable Long id) {
      invoiceStatisticCompanyInfo.setId(id);
      return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.updateById(invoiceStatisticCompanyInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceStatisticCompanyInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicestatisticcompanyinfos/{id}")
  public XfR patchUpdate(@RequestBody InvoiceStatisticCompanyInfo invoiceStatisticCompanyInfo,@PathVariable Long id) {
      InvoiceStatisticCompanyInfo upinvoiceStatisticCompanyInfo = invoiceStatisticCompanyInfoServiceImpl.getById(id);
      if(upinvoiceStatisticCompanyInfo != null){
        upinvoiceStatisticCompanyInfo = ObjectCopyUtils.copyProperties(invoiceStatisticCompanyInfo,upinvoiceStatisticCompanyInfo,true);
      }
      return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.updateById(upinvoiceStatisticCompanyInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicestatisticcompanyinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.removeById(id));
  }

  @PostMapping("/invoicestatisticcompanyinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_statistic_company_info");
     params.put("request", condition);

     return XfR.ok(invoiceStatisticCompanyInfoServiceImpl.querys(params));
  }

}
