package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.VehicleInfo;
import com.xforceplus.ultraman.app.openapirapi.service.IVehicleInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-04
 */
@RestController
public class VehicleInfoController {

  @Autowired
  private IVehicleInfoService vehicleInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param vehicleInfo ${table.comment}
   * @return
   */
  @GetMapping("/vehicleinfos" )
  public XfR getVehicleInfos(XfPage page, VehicleInfo vehicleInfo) {
    return XfR.ok(vehicleInfoServiceImpl.page(page, Wrappers.query(vehicleInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vehicleinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(vehicleInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param vehicleInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/vehicleinfos")
  public XfR save(@RequestBody VehicleInfo vehicleInfo) {
     return XfR.ok(vehicleInfoServiceImpl.save(vehicleInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param vehicleInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/vehicleinfos/{id}")
  public XfR putUpdate(@RequestBody VehicleInfo vehicleInfo,@PathVariable Long id) {
      vehicleInfo.setId(id);
      return XfR.ok(vehicleInfoServiceImpl.updateById(vehicleInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param vehicleInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vehicleinfos/{id}")
  public XfR patchUpdate(@RequestBody VehicleInfo vehicleInfo,@PathVariable Long id) {
      VehicleInfo upvehicleInfo = vehicleInfoServiceImpl.getById(id);
      if(upvehicleInfo != null){
        upvehicleInfo = ObjectCopyUtils.copyProperties(vehicleInfo,upvehicleInfo,true);
      }
      return XfR.ok(vehicleInfoServiceImpl.updateById(upvehicleInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vehicleinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(vehicleInfoServiceImpl.removeById(id));
  }

  @PostMapping("/vehicleinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "vehicle_info");
     params.put("request", condition);

     return XfR.ok(vehicleInfoServiceImpl.querys(params));
  }

}
