package com.xforceplus.ultraman.app.openapirapi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.openapirapi.entity.BaseStandardInvoiceItem;
import com.xforceplus.ultraman.app.openapirapi.service.IBaseStandardInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-09-18
 */
@RestController
public class BaseStandardInvoiceItemController {

  @Autowired
  private IBaseStandardInvoiceItemService baseStandardInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baseStandardInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/basestandardinvoiceitems" )
  public XfR getBaseStandardInvoiceItems(XfPage page, BaseStandardInvoiceItem baseStandardInvoiceItem) {
    return XfR.ok(baseStandardInvoiceItemServiceImpl.page(page, Wrappers.query(baseStandardInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basestandardinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baseStandardInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baseStandardInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/basestandardinvoiceitems")
  public XfR save(@RequestBody BaseStandardInvoiceItem baseStandardInvoiceItem) {
     return XfR.ok(baseStandardInvoiceItemServiceImpl.save(baseStandardInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baseStandardInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/basestandardinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody BaseStandardInvoiceItem baseStandardInvoiceItem,@PathVariable Long id) {
      baseStandardInvoiceItem.setId(id);
      return XfR.ok(baseStandardInvoiceItemServiceImpl.updateById(baseStandardInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baseStandardInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basestandardinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody BaseStandardInvoiceItem baseStandardInvoiceItem,@PathVariable Long id) {
      BaseStandardInvoiceItem upbaseStandardInvoiceItem = baseStandardInvoiceItemServiceImpl.getById(id);
      if(upbaseStandardInvoiceItem != null){
        upbaseStandardInvoiceItem = ObjectCopyUtils.copyProperties(baseStandardInvoiceItem,upbaseStandardInvoiceItem,true);
      }
      return XfR.ok(baseStandardInvoiceItemServiceImpl.updateById(upbaseStandardInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basestandardinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baseStandardInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/basestandardinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "base_standard_invoice_item");
     params.put("request", condition);

     return XfR.ok(baseStandardInvoiceItemServiceImpl.querys(params));
  }

}
